% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msc.uc.R
\name{msc.uc}
\alias{msc.uc}
\title{Cluster Analyses}
\usage{
msc.uc(files)
}
\arguments{
\item{files}{a character vector containing the uc file names (output of VSEARCH) e.g. all.minicircles.circ.id70.uc, all.minicircles.circ.id80.uc...}
}
\value{
\item{MSCs}{a numerical vector containing the number of MSC per percent identity.}
\item{perfect aligments}{a numerical vector containing the proportions of perfect alignments per percent identity.}
\item{insertions}{a table showing the length and the number of insertions across different percent identities.}
\item{deletions}{a table showing the length and the number of deletions across different percent identities.}
\item{plots}{different plots showing previous results.}
}
\description{
The msc.uc function allows you to check some clustering : insertions and deletions --> ask Fre.
The total amount of minicircle sequence clusters (MSCs) found per percent identity will be calculated as well as the number of gaps.
}
\examples{
data(exData)

### run function
\donttest{
ucs <- msc.uc(files = system.file("extdata", exData$ucs, package="rKOMICS"))

ucs$MSCs["100"] 
ucs$MSCs["97"] 

### results
ucs$plots
}

}
