% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching.R
\name{match_on_index}
\alias{match_on_index}
\title{Function for performing matching of controls to cases using the consultation files to generate a
dummy index date for controls.}
\usage{
match_on_index(cases, control_pool, index_var, match_vars,
  extra_conditions = "", index_diff_limit = 90, consult_path,
  n_controls = 5, cores = 1, import_fn = read.delim, ...)
}
\arguments{
\item{cases}{A dataframe of cases to which to match controls}

\item{control_pool}{A dataframe of possible contols to match to cases}

\item{index_var}{character string of the name of the variable containing index dates}

\item{match_vars}{character vector detailing the common variables in \code{cases} and 
\code{control_pool} to match on}

\item{extra_conditions}{character string detailing other matching constraints (see details)}

\item{index_diff_limit}{integer number of days before or after the case index date that 
dummy index dates can be picked from the consultation files}

\item{consult_path}{path to directory containing consultation files}

\item{n_controls}{integer the number of controls to attempt to match to each case}

\item{cores}{integer the number of processor cores to be used in processing}

\item{import_fn}{function name stipulating the function used to read the consultation files}

\item{\dots}{extra arguments to be passed to import_fn}
}
\value{
a dataframe of matched controls
}
\description{
Controls are matched on an arbitrary number of categrorical variables and on continuous 
 variables via the \code{extra_conditions} argument. Also the date at \code{index_var} is matched to the 
 eventdate in the consultation files, providing a dummy index date for controls of a consultaton
 within +/- \code{index_diff_limit} days of the index date.
 
 Note that the consultaton files must be in flat-file format (i.e. not as part of the database, 
 but as text (or other filetype, e.g stata dta) files).  Set the \code{import_fn} argument to 
 use different file formats (e.g. \code{foreign::read.dta} or \code{readstata13::read.dta13})
 
 The \code{extra_conditions} argument can add extra condtions to the matching criteria
 on top of the matching vars for example you could add "year > 1990".  You can wrap calls to 
 expressions in dotted brackets to automatically expand them.  This is particularly useful
 when you want to find the value for each individual case. Each case is denoted by \code{CASE}
 e.g. "start_date < .(CASE$start_date)" will ensure the start date for controls is prior to 
 the start date for the matched case.
}

