% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TMM_normalz.R
\name{cpm.normal}
\alias{cpm.normal}
\title{Calculate normalized depth for alleles}
\usage{
cpm.normal(
  het.table,
  method = c("TMM", "TMMex", "MedR", "QN"),
  logratioTrim = 0.3,
  sumTrim = 0.05,
  Weighting = TRUE,
  Acutoff = -1e+10,
  verbose = TRUE
)
}
\arguments{
\item{het.table}{allele depth table generated from the function
\code{hetTgen}}

\item{method}{character. method to be used (see details). Default \code{TMM}}

\item{logratioTrim}{numeric. percentage value (0 - 1) of variation to be
trimmed in log transformation}

\item{sumTrim}{numeric. amount of trim to use on the combined absolute
levels (\dQuote{A} values) for method \code{TMM}}

\item{Weighting}{logical, whether to compute (asymptotic binomial precision)
weights}

\item{Acutoff}{numeric, cutoff on \dQuote{A} values to use before trimming
(only for TMM(ex))}

\item{verbose}{logical. show progress}
}
\value{
Returns a list with (AD), a data frame of normalized depth values
similar to the output of \code{hetTgen} function and
(outliers) a list of outlier sample names
}
\description{
This function outputs the normalized depth values separately for each allele,
calculated using normalization factor with trimmed mean of M-values of
sample libraries, median ratios normalization or quantile normalization,
See details.
}
\details{
This function converts an observed depth value table to an
effective depth value table using several normalization methods;
\enumerate{
\item TMM normalization (See the original publication for more information).
It is different from the function \code{normz} only in calculation of the
counts per million is for separate alleles instead of the total depth.
The \code{TMMex} method is an extension of the \code{TMM} method for
large data sets containing SNPs exceeding 10000
\item The method \code{MedR} is median ratio normalization;
\item QN - quantile normalization (see  Maza, Elie, et al. 2013 for a
comparison of methods).
}
}
\examples{
\dontrun{data(ADtable)
ADnormalized<-cpm.normal(ADtable)}


}
\references{
\itemize{
\item{Robinson MD, Oshlack A (2010). A scaling normalization method for
differential expression analysis of RNA-seq data. Genome Biology 11, R25}
\item{Robinson MD, McCarthy DJ and Smyth GK (2010). edgeR: a Bioconductor
package for differential expression analysis of digital gene expression
data. Bioinformatics 26}
\item{Maza, Elie, et al. "Comparison of normalization methods for
differential gene expression analysis in RNA-Seq experiments: a matter of
relative size of studied transcriptomes." Communicative & integrative
biology 6.6 (2013): e25849}
}
}
\author{
Piyal Karunarathne, Qiujie Zhou
}
