% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_modules_timeSeries.R
\name{rAmCharts-shinymodules-ts}
\alias{rAmCharts-shinymodules-ts}
\alias{rAmChartsTimeSeriesUI}
\alias{rAmChartsTimeSeriesServer}
\title{Shiny module to render large time-series data with live server-client aggregation}
\usage{
rAmChartsTimeSeriesUI(id, width = "100\%", height = "400px")

rAmChartsTimeSeriesServer(input, output, session, data, col_date,
  col_series, maxPoints = shiny::reactive(600),
  tz = shiny::reactive("UTC"), ts = shiny::reactive(c("5 min",
  "10 min", "30 min", "hour", "3 hour", "12 hour", "day", "week", "month",
  "year")), fun_aggr = shiny::reactive("mean"),
  treat_missing = shiny::reactive(FALSE),
  maxgap = shiny::reactive(Inf), type_aggr = shiny::reactive("first"),
  main = shiny::reactive(""), ylab = shiny::reactive(""),
  color = shiny::reactive(c("#2E2EFE", "#31B404", "#FF4000", "#AEB404")),
  bullet = shiny::reactive(NULL), bulletSize = shiny::reactive(2),
  linetype = shiny::reactive(c(0, 5, 10, 15, 20)),
  linewidth = shiny::reactive(c(1, 1, 1, 1, 1, 1)),
  fillAlphas = shiny::reactive(0), precision = shiny::reactive(1),
  export = shiny::reactive(FALSE), legend = shiny::reactive(TRUE),
  legendPosition = shiny::reactive("bottom"),
  legendHidden = shiny::reactive(FALSE),
  ZoomButton = shiny::reactive(data.frame(Unit = "MAX", multiple = 1,
  label = "All")), ZoomButtonPosition = shiny::reactive("bottom"),
  periodFieldsSelection = shiny::reactive(FALSE),
  scrollbar = shiny::reactive(TRUE),
  scrollbarPosition = shiny::reactive("bottom"),
  scrollbarHeight = shiny::reactive(40),
  scrollbarGraph = shiny::reactive(NULL),
  cursor = shiny::reactive(TRUE),
  cursorValueBalloonsEnabled = shiny::reactive(TRUE),
  creditsPosition = shiny::reactive("top-right"),
  group = shiny::reactive(NULL))
}
\arguments{
\item{id}{character, used to specify namesapce, see \code{shiny::\link[shiny]{NS}}}

\item{width}{\code{character}, the width of the chart container. For \code{amChartsOutput}.}

\item{height}{\code{character}, the height of the chart container. For \code{amChartsOutput}.}

\item{input}{standard, \code{shiny} input}

\item{output}{standard, \code{shiny} output}

\item{session}{standard, \code{shiny} session}

\item{data}{: data.frame to transform.}

\item{col_date}{Date column name, default to "date".
Must be "POSIXct"}

\item{col_series}{Column name of quantitative variable(s) to be
transformed. Default to setdiff(colnames(data), "date")}

\item{maxPoints}{: Maximal number of rows in results}

\item{tz}{: Timezone of result. Defaut to "UTC".}

\item{ts}{All enabled aggregation. Default to c("5 min",  "10 min", "30 min", "hour", "3 hour", "12 hour", "day", "week", "month", "year").
Can be a number, in seconds, or a character string
containing one of "min", "hour", "day"....
This can optionally be preceded by a positive integer
and a space}

\item{fun_aggr}{: Aggregation function to use ("min", "max", "sum", "mean", "first", "last").
Default to "mean".}

\item{treat_missing}{: Boolean. Default to FALSE
Whether or not to interpolate missing values ?
see \code{na.approx}}

\item{maxgap}{When interpolate missing values with \code{na.approx}.
Maximum number of consecutive NAs to fill. Defaut to Inf.}

\item{type_aggr}{\code{character} Type of aggregation
\itemize{
 \item{"first"}{ : Date/Time result is equal to minimum of sequence, and this minimum is included in aggregation}
 \item{"last"}{ : Date/Time result is equal to maximum of sequence, and this maximum is included in aggregation}
}}

\item{main}{\code{character}, title.}

\item{ylab}{\code{character}, value axis label.}

\item{color}{\code{character}, color of series (in hexadecimal).}

\item{bullet}{\code{character}, point shape. Possible values are : "diamond", "square", 
"bubble",  "yError", "xError", "round", "triangleLeft", "triangleRight", "triangleUp"}

\item{bulletSize}{\code{numeric}, size of bullet.}

\item{linetype}{\code{numeric}, line type, 0 : solid, number : dashed length}

\item{linewidth}{\code{numeric}, line width.}

\item{fillAlphas}{\code{numeric}, fill. Between 0 (no fill) to 1.}

\item{precision}{\code{numeric}, default set to  1.}

\item{export}{\code{logical}, default set to  FALSE. TRUE to display export feature.}

\item{legend}{\code{logical}, enabled or not legend ? Defaut to TRUE.}

\item{legendPosition}{\code{character}, legend position. Possible values are :
"left", "right", "bottom", "top"}

\item{legendHidden}{\code{logical} hide some series on rendering ? Defaut to FALSE}

\item{ZoomButton}{\code{data.frame}, 3 or 4 columns : 
\itemize{
 \item{"Unit"}{ : Character. Times unit. 'ss', 'mm', 'hh', 'DD', 'MM', 'YYYY'}
 \item{"multiple"}{ : Numeric. multiple*unit }
 \item{"label"}{ : Character. button's label }
 \item{"selected"}{ : Boolean. Optional. To set initial selection. (One TRUE, others FALSE)}
}}

\item{ZoomButtonPosition}{\code{character}, zoom button position. Possible values are :
"left", "right", "bottom", "top"}

\item{periodFieldsSelection}{\code{boolean}, using zoom button, add also two fields to select period ?}

\item{scrollbar}{\code{boolean}, enabled or not scrollbar ? Defaut to TRUE.}

\item{scrollbarPosition}{\code{character}, scrollbar position. Possible values are :
"left", "right", "bottom", "top"}

\item{scrollbarHeight}{\code{numeric}, height of scroll bar. Default : 40.}

\item{scrollbarGraph}{\code{character}, name of serie (column) to print in scrollbar. Defaut to NULL.}

\item{cursor}{\code{boolean}, enabled or not cursor ? Defaut to TRUE.}

\item{cursorValueBalloonsEnabled}{\code{boolean}, if cursor, enabled or not balloons on cursor ? Defaut to TRUE.}

\item{creditsPosition}{\code{character}, credits position. Possible values are :
"top-right", "top-left", "bottom-right", "bottom-left"}

\item{group}{\code{character}, like in \code{dygraphs}, for synchronization in \code{shiny} or \code{rmarkdown}.}
}
\value{
a reactive expression with aggregate data and ts
}
\description{
Shiny module to render large time-series data with live server-client aggregation
}
\examples{

\dontrun{

library(shiny)
library(rAmCharts)

# number of points
n <- 1000000
data <- data.frame(date = seq(c(ISOdate(1999,12,31)), by = "5 min", length.out = n),
                          value = rnorm(n, 100, 50))

# maximun of points in javascript
max_points <- 1000

# Call module in UI
ui <- fluidPage(
  rAmChartsTimeSeriesUI("ts_1", height = "600px"),
  h4(textOutput("ts"))
)

# Define server
server <- function(input, output) {
  
  # Call module in server
  res <- callModule(rAmChartsTimeSeriesServer, "ts_1", reactive(data), reactive("date"), 
     reactive("value"), maxPoints = shiny::reactive(max_points),
     main = reactive("Example of rAmChartsTimeSeries module"),
     color = reactive("red"), periodFieldsSelection = reactive(TRUE)
   )
   
  # show module return and print ts
  output$ts <- renderText({
    print(res())
    paste0("Current ts : ", res()$ts)
  })
 
}

# Run the application 
shinyApp(ui = ui, server = server)

}

}
