% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessments.R
\name{assessments}
\alias{assessments}
\title{Download Assessment Decisions}
\usage{
assessments(
  assessment_unit_id = NULL,
  state_code = NULL,
  organization_id = NULL,
  reporting_cycle = NULL,
  use = NULL,
  use_support = NULL,
  parameter = NULL,
  parameter_status_name = NULL,
  probable_source = NULL,
  agency_code = NULL,
  ir_category = NULL,
  state_ir_category_code = NULL,
  multicategory_search = NULL,
  last_change_later_than_date = NULL,
  last_change_earlier_than_date = NULL,
  return_count_only = FALSE,
  exclude_assessments = FALSE,
  tidy = TRUE,
  ...
)
}
\arguments{
\item{assessment_unit_id}{(character) Specify the specific assessment unit assessment data to return. Multiple values can be provided. optional}

\item{state_code}{(character) Filters returned assessments to those from the specified state. optional}

\item{organization_id}{(character) Filters the returned assessments to those belonging to the specified organization. optional}

\item{reporting_cycle}{(character) Filters the returned assessments to those for the specified reporting cycle. The reporting cycle refers to the four-digit year that the reporting cycle ended. Defaults to the current cycle. optional}

\item{use}{(character) Filters the returned assessments to those with the specified uses. Multiple values can be provided. optional}

\item{use_support}{(character) Filters returned assessments to those fully supporting the specified uses or that are threatened. Multiple values can be provided. Allowable values include \code{"X"}= Not Assessed, \code{"I"}= Insufficient Information, \code{"F"}= Fully Supporting, \code{"N"}= Not Supporting, and \code{"T"}= Threatened. optional}

\item{parameter}{(character) Filters the returned assessments to those with one or more of the specified parameters. Multiple values can be provided. optional}

\item{parameter_status_name}{(character) Filters the returned assessments to those with one or more associated parameters meeting the provided value. Valid values are \code{"Meeting Criteria"}, \code{"Cause"}, \code{"Observed Effect"}. Multiple valuse can be provided. optional}

\item{probable_source}{(character) Filters the returned assessments to those having the specified probable source. Multiple values can be provided. optional}

\item{agency_code}{(character) Filters the returned assessments to those by the type of agency responsible for the assessment. Allowed values are \code{"E"}=EPA, \code{"S"}=State, \code{"T"}=Tribal. optional}

\item{ir_category}{(character) Filters the returned assessments to those having the specified IR category. Multiple values can be provided. optional}

\item{state_ir_category_code}{(character) Filters the returned assessments to include those having the provided codes.}

\item{multicategory_search}{(character) Specifies whether to search at multiple levels.  If this parameter is set to “Y” then the query applies the EPA IR Category at the Assessment, UseAttainment, and Parameter levels; if the parameter is set to “N” it looks only at the Assessment level.}

\item{last_change_later_than_date}{(character) Filters the returned assessments to only those last changed after the provided date. Must be a character
with format: \code{"yyyy-mm-dd"}. optional}

\item{last_change_earlier_than_date}{(character) Filters the returned assessments to only those last changed before the provided date. Must be a character
with format: \code{"yyyy-mm-dd"}. optional}

\item{return_count_only}{(logical) If \code{TRUE} returns only the count of
actions the match the query. defaults to \code{FALSE}}

\item{exclude_assessments}{(logical) If \code{TRUE} returns only the documents associated with the Assessment cycle instead of the assessment data. Defaults is \code{FALSE}.}

\item{tidy}{(logical) \code{TRUE} (default) the function returns a tidied tibble. \code{FALSE} the function returns the raw JSON string.}

\item{...}{list of curl options passed to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\value{
If \code{count = TRUE} returns a tibble that summarizes the count of
actions returned by the query. If \code{count = FALSE} returns a list of
tibbles including documents, use assessment data, and parameters assessment
data identified by the query. If \code{tidy = FALSE} the raw JSON string is
returned, else the JSON data is parsed and returned as tibbles.
}
\description{
Download Assessment Decisions
}
\details{
One or more of the following arguments must be included:
\code{action_id}, \code{assessment_unit_id}, \code{state_code} or
\code{organization_id}. Multiple values are allowed for indicated arguments
and should be included as a comma separated values in the string (eg.
\code{organization_id="TCEQMAIN,DCOEE"}).
}
\note{
See \link{domain_values} to search values that can be queried. Data
downloaded from the EPA webservice is automatically cached to reduce
uneccessary calls to the server. To managed cached files see
\link{rATTAINS_caching}.
}
\examples{

\dontrun{

## Return all assessment decisions with specified parameters
assessments(organization_id = "SDDENR",
probable_source = "GRAZING IN RIPARIAN OR SHORELINE ZONES")

## Returns the raw JSONs instead:
assessments(organization_id = "SDDENR",
probable_source = "GRAZING IN RIPARIAN OR SHORELINE ZONES", tidy = FALSE)
}
}
