## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
httptest2::start_vignette("../man/figures/r311")
library(r311)

## -----------------------------------------------------------------------------
o311_endpoints()

## -----------------------------------------------------------------------------
o311_add_endpoint(
  name = "Rostock Test",
  root = "https://demo.klarschiff-hro.de/backoffice/citysdk/",
  jurisdiction = "rostock.de"
)

## -----------------------------------------------------------------------------
nrow(o311_endpoints())

## -----------------------------------------------------------------------------
o311_api("Rostock Test")

## -----------------------------------------------------------------------------
o311_ok()

## -----------------------------------------------------------------------------
o311_services()

## -----------------------------------------------------------------------------
o311_requests()

## -----------------------------------------------------------------------------
o311_requests(service_code = "16")

## -----------------------------------------------------------------------------
o311_request("4")

## -----------------------------------------------------------------------------
o311_api("Rostock, DE")
o311_request_all(max_pages = 2)

## -----------------------------------------------------------------------------
tickets <- o311_requests(keyword = "idea", max_requests = 50)

## -----------------------------------------------------------------------------
o311_requests(just_count = TRUE)

## -----------------------------------------------------------------------------
poly <- o311_query("areas")
plot(poly$grenze)
plot(tickets$geometry, add = TRUE, pch = 16)

## -----------------------------------------------------------------------------
o311_reset_endpoints()

