% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_table_content.R
\name{rtf_table_content}
\alias{rtf_table_content}
\title{Create RTF Table Body Encode}
\usage{
rtf_table_content(
  tbl,
  col_total_width = attr(tbl, "page")$col_width,
  use_border_bottom = FALSE
)
}
\arguments{
\item{tbl}{A data frame.}

\item{col_total_width}{Column total width for the table. Default is the corresponding attribute from \code{tbl}.}

\item{use_border_bottom}{A logical value of using the bottom border. Default is the corresponding attribute from \code{tbl}.}
}
\description{
Create RTF Table Body Encode
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Define table begin and end in RTF syntax.
   \item Define cell justification using `justification()` and `vertical_justification`, then covert the cell from inch to twip using `inch_to_twip()` in RTF syntax.
   \item Define cell border type using `border_type()` and cell border width in RTF syntax.
   \item Define cell border color using `color_table()` in RTF syntax.
   \item Define cell background color using input variable text_background_color in RTF syntax.
   \item Define cell size using `cell_size()` in RTF syntax.
   \item Combine cell component attributes into a single code string.
   \item Define cell content in encoded RTF syntax.
   \item Check if cell content format is a valid value.
   \item Combine cell content and content component attributes into a single code string.
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

