/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.visitors;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.Field;

public class FieldUtil {
    private FieldUtil() {
    }

    public static <F extends Field<?>> Map<String, F> nameMap(Collection<? extends F> fields) {
        LinkedHashMap<String, Field> fieldMap = new LinkedHashMap<String, Field>(2 * fields.size());
        for (Field field : fields) {
            String name = field.requireName();
            Field previousField = fieldMap.put(name, field);
            if (previousField == null) continue;
            throw new IllegalArgumentException("Fields " + FieldUtil.format(field) + " and " + FieldUtil.format(previousField) + " have the same name " + name);
        }
        return fieldMap;
    }

    public static <F extends Field<?>> Set<String> nameSet(Collection<? extends F> fields) {
        Map<String, F> fieldMap = FieldUtil.nameMap(fields);
        return fieldMap.keySet();
    }

    public static <F extends Field<?>> Collection<F> selectAll(Collection<? extends F> fields, Set<String> names) {
        return FieldUtil.selectAll(fields, names, false);
    }

    public static <F extends Field<?>> Collection<F> selectAll(Collection<? extends F> fields, Set<String> names, boolean allowPartialSelection) {
        LinkedHashMap<String, Field> fieldMap = new LinkedHashMap<String, Field>(2 * names.size());
        for (Field field : fields) {
            Field previousField;
            String name = field.requireName();
            if (!names.contains(name) || (previousField = fieldMap.put(name, field)) == null) continue;
            throw new IllegalArgumentException("Fields " + FieldUtil.format(field) + " and " + FieldUtil.format(previousField) + " have the same name " + name);
        }
        if (!allowPartialSelection && fieldMap.size() < names.size()) {
            LinkedHashSet<String> unmatchedNames = new LinkedHashSet<String>(names);
            unmatchedNames.removeAll(fieldMap.keySet());
            throw new IllegalArgumentException("Name(s) " + unmatchedNames + " do not match any fields");
        }
        return fieldMap.values();
    }

    private static String format(Field<?> field) {
        return String.valueOf(field);
    }
}

