/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.dmg.pmml.support_vector_machine.LinearKernel;
import org.dmg.pmml.support_vector_machine.PolynomialKernel;
import org.dmg.pmml.support_vector_machine.RadialBasisKernel;
import org.dmg.pmml.support_vector_machine.SigmoidKernel;
import org.dmg.pmml.support_vector_machine.SupportVectorMachineModel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.FortranMatrix;
import org.jpmml.converter.Label;
import org.jpmml.converter.Matrix;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.OutlierTransformation;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.Transformation;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.support_vector_machine.LibSVMUtil;
import org.jpmml.rexp.DecorationUtil;
import org.jpmml.rexp.Formula;
import org.jpmml.rexp.FormulaUtil;
import org.jpmml.rexp.ModelConverter;
import org.jpmml.rexp.RBooleanVector;
import org.jpmml.rexp.RDoubleVector;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExpEncoder;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RIntegerVector;
import org.jpmml.rexp.RStringVector;
import org.jpmml.rexp.RVector;
import org.jpmml.rexp.XLevelsFormulaContext;

public class SVMConverter
extends ModelConverter<RGenericVector> {
    private static final Function<Double, Double> FUNCTION_NEGATE = new Function<Double, Double>(){

        public Double apply(Double value) {
            return -1.0 * value;
        }
    };

    public SVMConverter(RGenericVector svm) {
        super(svm);
    }

    @Override
    public void encodeSchema(RExpEncoder encoder) {
        RGenericVector svm = (RGenericVector)this.getObject();
        if (svm.hasElement("terms")) {
            this.encodeFormula(encoder);
        } else {
            this.encodeNonFormula(encoder);
        }
    }

    public SupportVectorMachineModel encodeModel(Schema schema) {
        SupportVectorMachineModel supportVectorMachineModel;
        RGenericVector svm = (RGenericVector)this.getObject();
        RDoubleVector type = svm.getDoubleElement("type");
        RDoubleVector kernel = svm.getDoubleElement("kernel");
        RDoubleVector degree = svm.getDoubleElement("degree");
        RDoubleVector gamma = svm.getDoubleElement("gamma");
        RDoubleVector coef0 = svm.getDoubleElement("coef0");
        RGenericVector yScale = svm.getGenericElement("y.scale");
        RIntegerVector nSv = svm.getIntegerElement("nSV");
        RDoubleVector sv = svm.getDoubleElement("SV");
        RDoubleVector rho = svm.getDoubleElement("rho");
        RDoubleVector coefs = svm.getDoubleElement("coefs");
        Type svmType = Type.values()[ValueUtil.asInt((Number)((Number)type.asScalar()))];
        Kernel svmKernel = Kernel.values()[ValueUtil.asInt((Number)((Number)kernel.asScalar()))];
        org.dmg.pmml.support_vector_machine.Kernel pmmlKernel = svmKernel.createKernel((Double)degree.asScalar(), (Double)gamma.asScalar(), (Double)coef0.asScalar());
        switch (svmType) {
            case C_CLASSIFICATION: 
            case NU_CLASSIFICATION: {
                supportVectorMachineModel = SVMConverter.encodeClassification(pmmlKernel, sv, nSv, rho, coefs, schema);
                break;
            }
            case ONE_CLASSIFICATION: {
                OutlierTransformation outlier = new OutlierTransformation(){

                    public Expression createExpression(FieldRef fieldRef) {
                        return PMMLUtil.createApply((String)"lessOrEqual", (Expression[])new Expression[]{fieldRef, PMMLUtil.createConstant((Number)0.0)});
                    }
                };
                supportVectorMachineModel = SVMConverter.encodeRegression(pmmlKernel, sv, rho, coefs, schema).setOutput(ModelUtil.createPredictedOutput((FieldName)FieldName.create((String)"decisionFunction"), (OpType)OpType.CONTINUOUS, (DataType)DataType.DOUBLE, (Transformation[])new Transformation[]{outlier}));
                if (yScale == null || yScale.size() <= 0) break;
                throw new IllegalArgumentException();
            }
            case EPS_REGRESSION: 
            case NU_REGRESSION: {
                supportVectorMachineModel = SVMConverter.encodeRegression(pmmlKernel, sv, rho, coefs, schema);
                if (yScale == null || yScale.size() <= 0) break;
                RDoubleVector yScaledCenter = yScale.getDoubleElement("scaled:center");
                RDoubleVector yScaledScale = yScale.getDoubleElement("scaled:scale");
                supportVectorMachineModel.setTargets(ModelUtil.createRescaleTargets((Number)(-1.0 * (Double)yScaledScale.asScalar()), (Number)((Number)yScaledCenter.asScalar()), (ContinuousLabel)((ContinuousLabel)schema.getLabel())));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return supportVectorMachineModel;
    }

    private void encodeFormula(RExpEncoder encoder) {
        RGenericVector svm = (RGenericVector)this.getObject();
        RDoubleVector type = svm.getDoubleElement("type");
        RDoubleVector sv = svm.getDoubleElement("SV");
        RVector<?> levels = svm.getVectorElement("levels");
        RExp terms = (RExp)svm.getElement("terms");
        RGenericVector xlevels = DecorationUtil.getGenericElement(svm, "xlevels");
        Type svmType = Type.values()[ValueUtil.asInt((Number)((Number)type.asScalar()))];
        RStringVector rowNames = sv.dimnames(0);
        RStringVector columnNames = sv.dimnames(1);
        XLevelsFormulaContext context = new XLevelsFormulaContext(xlevels);
        Formula formula = FormulaUtil.createFormula(terms, context, encoder);
        switch (svmType) {
            case C_CLASSIFICATION: 
            case NU_CLASSIFICATION: {
                FormulaUtil.setLabel(formula, terms, levels, encoder);
                break;
            }
            case ONE_CLASSIFICATION: {
                encoder.setLabel((Label)new ContinuousLabel(null, DataType.DOUBLE));
                break;
            }
            case EPS_REGRESSION: 
            case NU_REGRESSION: {
                FormulaUtil.setLabel(formula, terms, null, encoder);
            }
        }
        FormulaUtil.addFeatures(formula, columnNames, true, encoder);
        this.scaleFeatures(encoder);
    }

    private void encodeNonFormula(RExpEncoder encoder) {
        DataField dataField;
        RGenericVector svm = (RGenericVector)this.getObject();
        RDoubleVector type = svm.getDoubleElement("type");
        RDoubleVector sv = svm.getDoubleElement("SV");
        RVector<?> levels = svm.getVectorElement("levels");
        Type svmType = Type.values()[ValueUtil.asInt((Number)((Number)type.asScalar()))];
        RStringVector rowNames = sv.dimnames(0);
        RStringVector columnNames = sv.dimnames(1);
        FieldName name = FieldName.create((String)"_target");
        switch (svmType) {
            case C_CLASSIFICATION: 
            case NU_CLASSIFICATION: {
                RStringVector stringLevels = (RStringVector)levels;
                dataField = encoder.createDataField(name, OpType.CATEGORICAL, DataType.STRING, stringLevels.getValues());
                encoder.setLabel(dataField);
                break;
            }
            case ONE_CLASSIFICATION: {
                encoder.setLabel((Label)new ContinuousLabel(null, DataType.DOUBLE));
                break;
            }
            case EPS_REGRESSION: 
            case NU_REGRESSION: {
                DataField dataField2 = encoder.createDataField(name, OpType.CONTINUOUS, DataType.DOUBLE);
                encoder.setLabel(dataField2);
            }
        }
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = columnNames.getValue(i);
            dataField = encoder.createDataField(FieldName.create((String)columnName), OpType.CONTINUOUS, DataType.DOUBLE);
            encoder.addFeature((Field<?>)dataField);
        }
        this.scaleFeatures(encoder);
    }

    private void scaleFeatures(RExpEncoder encoder) {
        RGenericVector svm = (RGenericVector)this.getObject();
        RDoubleVector sv = svm.getDoubleElement("SV");
        RBooleanVector scaled = svm.getBooleanElement("scaled");
        RGenericVector xScale = svm.getGenericElement("x.scale");
        RStringVector rowNames = sv.dimnames(0);
        RStringVector columnNames = sv.dimnames(1);
        List<Feature> features = encoder.getFeatures();
        if (scaled.size() != columnNames.size() || scaled.size() != features.size()) {
            throw new IllegalArgumentException();
        }
        RDoubleVector xScaledCenter = xScale.getDoubleElement("scaled:center");
        RDoubleVector xScaledScale = xScale.getDoubleElement("scaled:scale");
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = columnNames.getValue(i);
            if (!scaled.getValue(i).booleanValue()) continue;
            Feature feature = features.get(i);
            Double center = (Double)xScaledCenter.getElement(columnName);
            Double scale = (Double)xScaledScale.getElement(columnName);
            if (ValueUtil.isZero((Number)center) && ValueUtil.isOne((Number)scale)) continue;
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            FieldRef expression = continuousFeature.ref();
            if (!ValueUtil.isZero((Number)center)) {
                expression = PMMLUtil.createApply((String)"-", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Number)center)});
            }
            if (!ValueUtil.isOne((Number)scale)) {
                expression = PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Number)scale)});
            }
            DerivedField derivedField = encoder.createDerivedField(FeatureUtil.createName((String)"scale", (Feature)feature), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)expression);
            features.set(i, (Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
        }
    }

    private static SupportVectorMachineModel encodeClassification(org.dmg.pmml.support_vector_machine.Kernel kernel, RDoubleVector sv, RIntegerVector nSv, RDoubleVector rho, RDoubleVector coefs, Schema schema) {
        RStringVector rowNames = sv.dimnames(0);
        RStringVector columnNames = sv.dimnames(1);
        return LibSVMUtil.createClassification((org.dmg.pmml.support_vector_machine.Kernel)kernel, (Matrix)new FortranMatrix(sv.getValues(), rowNames.size(), columnNames.size()), nSv.getValues(), rowNames.getValues(), rho.getValues(), (List)Lists.transform(coefs.getValues(), FUNCTION_NEGATE), (Schema)schema);
    }

    private static SupportVectorMachineModel encodeRegression(org.dmg.pmml.support_vector_machine.Kernel kernel, RDoubleVector sv, RDoubleVector rho, RDoubleVector coefs, Schema schema) {
        RStringVector rowNames = sv.dimnames(0);
        RStringVector columnNames = sv.dimnames(1);
        return LibSVMUtil.createRegression((org.dmg.pmml.support_vector_machine.Kernel)kernel, (Matrix)new FortranMatrix(sv.getValues(), rowNames.size(), columnNames.size()), rowNames.getValues(), (Number)((Number)rho.asScalar()), (List)Lists.transform(coefs.getValues(), FUNCTION_NEGATE), (Schema)schema);
    }

    private static enum Kernel {
        LINEAR{

            public LinearKernel createKernel(Double degree, Double gamma, Double coef0) {
                return new LinearKernel();
            }
        }
        ,
        POLYNOMIAL{

            public PolynomialKernel createKernel(Double degree, Double gamma, Double coef0) {
                return new PolynomialKernel().setGamma((Number)gamma).setCoef0((Number)coef0).setDegree((Number)degree);
            }
        }
        ,
        RADIAL{

            public RadialBasisKernel createKernel(Double degree, Double gamma, Double coef0) {
                return new RadialBasisKernel().setGamma((Number)gamma);
            }
        }
        ,
        SIGMOID{

            public SigmoidKernel createKernel(Double degree, Double gamma, Double coef0) {
                return new SigmoidKernel().setGamma((Number)gamma).setCoef0((Number)coef0);
            }
        };


        public abstract org.dmg.pmml.support_vector_machine.Kernel createKernel(Double var1, Double var2, Double var3);
    }

    private static enum Type {
        C_CLASSIFICATION,
        NU_CLASSIFICATION,
        ONE_CLASSIFICATION,
        EPS_REGRESSION,
        NU_REGRESSION;

    }
}

