% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quint.bootstrapCI.R
\name{quint.bootstrapCI}
\alias{quint.bootstrapCI}
\title{Bootstrap method to compute confidence intervals for Qualitative Interaction Trees (Quint)}
\usage{
quint.bootstrapCI(tree, n_boot, boot_r = 1)
}
\arguments{
\item{tree}{a (pruned) quint object of class \code{quint}.}

\item{n_boot}{number of bootstrap samples.}

\item{boot_r}{bootstrap sample size expressed as proportion of total sample size. Default value is 1.}
}
\value{
Returns two lists: A first one ($tree) containing an object of the class \code{quint}, and a list ($bootinfo) with
estimates obtained from the bootstrap procedure containing the following components:
  \item{nleaves}{vector containing the number of leaves in each of the estimated trees in the bootstrap samples.}
  \item{meanT_1}{a matrix containing for each bootstrap sample (= rows) the mean outcome for Treatment A (T=1) in each leaf of the input quint tree (= columns) using the subjects in the intersection.}
  \item{meanT_2}{a matrix containing for each bootstrap sample (= rows) the mean outcome for Treatment B (T=2) in each leaf of the input quint tree (= columns) using the subjects in the intersection.a matrix containing the mean outcome for Treatment 2 in each leaf using the subjects in the intersection.}
  \item{meandif}{a matrix containing the difference in means between Treatment A and Treatment B in each leaf for each bootstrap sample.}
  \item{bias_est}{vector containing the bias in each leaf of the quint tree.}
  \item{meanboot}{vector containing the bootstrap estimates of the difference of means between treatments in each leaf.}
  \item{CIs}{vector containing the confidence intervals of the estimate of the difference of means between treatments in each leaf.}
  \item{se_est}{vector containing the new estimates of the standard error of the difference of means between treatments in each leaf.}
}
\description{
A bootstrap algorithm based on Loh et al. (2015) to estimate the confidence intervals of the difference
in mean outcome between the two treatments in each leaf.
}
\details{
The details of this validation procedure are described in "Instability of
  QUalitative INteraction Trees: Quantifying uncertainty in decision trees." (
  https://openaccess.leidenuniv.nl/handle/1887/83059)
}
\examples{
\dontrun{data(bcrp)
formula1<- I(cesdt1-cesdt3)~cond | nationality+marital+wcht1+age+
  trext+comorbid+disopt1+uncomt1+negsoct1

set.seed(10)
control1<-quint.control(maxl=5, B=2, crit="dm")
quint1<-quint(formula1, data= subset(bcrp,bcrp$cond<3),control=control1) #Grow a QUINT tree

prquint1<-prune(quint1) #Prune tree to optimal size

bootquint1<-quint.bootstrapCI(prquint1, n_boot = 5) #apply the bootstrap procedure

#the summary of the tree with the new standard errors obtained from the bootstrap procedure
summary(bootquint1$tree)

#all results of the bootstrap procedure
bootquint1$bootinfo

#plot wiht 95\% confidence intervals using the new standard errors
plot(bootquint1$tree) }
}
\references{
Dusseldorp E. and Van Mechelen I. (2014). Qualitative interaction trees:
  a tool to identify qualitative treatment-subgroup interactions.
  \emph{Statistics in Medicine, 33}(2), 219-237. DOI: 10.1002/sim.5933.
  Beck C., Dusseldorp E. and Fokkema M. (2019). Instability of
  QUalitative INteraction Trees: Quantifying uncertainty in decision trees.
  (https://openaccess.leidenuniv.nl/handle/1887/83059))
}
\seealso{
\code{\link{quint}}, \code{\link{prune.quint}}, \code{\link{quint.control}}
}
