% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{subset-cohorts}
\alias{subset-cohorts}
\alias{[,cohorts,missing,missing,missing-method}
\alias{[,cohorts,numeric,missing,missing-method}
\alias{[,cohorts,character,missing,missing-method}
\title{Subset a cohorts object}
\usage{
\S4method{[}{cohorts,missing,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{cohorts,numeric,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{cohorts,character,missing,missing}(x, i, j, ..., drop = FALSE)
}
\arguments{
\item{x}{A \linkS4class{cohorts} object.}

\item{i}{Position of the identifier or the name of the identifier itself.}

\item{j}{Not used.}

\item{...}{Additional arguments not used here.}

\item{drop}{Not used.}
}
\value{
A \linkS4class{cohorts} object.
}
\description{
You can subset \linkS4class{cohorts} by identifier or by position using the
\code{`[`} operator.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get a few cohorts by their symbol:
my_cohorts <- get_cohorts(c('23andMe', 'BioImage', 'Rotterdam-SI', 'SGWAS'),
                progress_bar = FALSE)

#
# Subsetting by position
#
my_cohorts[c(1, 3)]

#
# Subsetting by cohort symbol (character)
#
my_cohorts[c('23andMe', 'SGWAS')]
\dontshow{\}) # examplesIf}
}
\keyword{internal}
