% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cybersec.R
\name{extract_IP}
\alias{extract_IP}
\title{Extract all IP addresses from a string}
\usage{
extract_IP(input)
}
\arguments{
\item{input}{input string containing IP}
}
\value{
extract_IP returns a vector of IP addresses
}
\description{
Parse a string and vectorize the IP addresses within it
}
\examples{
\donttest{
# Extract all IP addresses from a string

# Example 1
# This example demonstrates the separate
# extraction of an IP address one per vector element:
str1 = c("Two IP(66.544.33.54) addresses
were discovered in the scan.
One was at 92.234.1.0.",
"The other IP was 62.3.45.255.")
extract_IP(str1)

# Example 2
# This example demonstrates the extraction
# of multiple IP addresses from a single vector element:
str2 = "Two IP addresses were discovered
in the scan. One was at 92.234.1.0.
The other IP was 62.3.45.255."
extract_IP(str2)
}
}
