% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-other.R
\name{clickValues}
\alias{clickValues}
\alias{clickExtent}
\alias{clickCoordinates}
\alias{.clickCoord}
\title{Mouse interactions with Plots}
\usage{
clickValues(n = 1)

clickExtent(devNum = NULL, plot.it = TRUE)

clickCoordinates(n = 1)

.clickCoord(X, n = 1, gl = NULL)
}
\arguments{
\item{n}{The number of mouse clicks to do.}

\item{devNum}{The device number for the new plot to be plotted on.}

\item{plot.it}{Logical. If \code{TRUE} a new plotting window is made for the
new extent. Default \code{TRUE}.}

\item{X}{The raster object whose values will be returned where mouse clicks occur.}

\item{gl}{An object created by a call to \code{grid.locator}.}
}
\value{
\code{clickValues} returns the layer names and values at the clicked points.
\code{clickExtent} invisibly returns the extent object, and optionally plots
it in a new device window.
\code{clickCoordinates} returns the xy coordinates in the units of the plot clicked on.
}
\description{
These functions use \code{grid.locator}. The primary two user-level functions are
\code{clickValues} and \code{clickExtent}. These functions automatically select
the correct viewport (i.e., map) where the mouse clicks occurred so the user
does not have to manually specify which map is being clicked on.
This works for \code{Raster*}, \code{SpatialPoints*}, and \code{SpatialPolygons*} objects.
}
\details{
\code{clickValues} is equivalent to running \code{X[SpatialPoints(locator(n))]}, where
X is the raster being clicked on, in base graphics. This function determines which place in the
grid.layout was clicked and makes all appropriate calculations to determine the value
on the raster(s) at that or those location(s). It should be noted that when zooming in
to rasters, plotting of rasters will only allow for complete pixels to be plotted, even
if the extent is not perfectly in line with pixel edges. As a result, when values
returned by this function may be slightly off (<0.5 pixel width).

\code{clickExtent} is for drawing an extent with two mouse clicks on a given Plotted map.

\code{clickCoordinates} is the workhorse function that determines which plot has been
clicked on and passes this plot name and the clicked coordinates to \code{.clickCoord}.

\code{.clickCoord} is intended for internal use and is called by other functions here.
}
\examples{
\dontrun{
  library(igraph)
  library(raster)
  
  files <- system.file("maps", package = "quickPlot") \%>\%
    dir(., full.names = TRUE, pattern = "tif")
  maps <- lapply(files, function(x) raster(x))
  names(maps) <- sapply(basename(files), function(x) {
    strsplit(x, split = "\\\\.")[[1]][1]
  })
  landscape <- stack(maps$DEM, maps$forestCover, maps$habitatQuality)
  
  clearPlot()
  Plot(landscape)
  clickValues(3) # click at three locations on the Plot device
  
  clearPlot()
  Plot(landscape)
  e <- clickExtent() # click at two locations on the Plot device
  print(e)
}

}
\author{
Eliot McIntire
}
\keyword{internal}
