% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psymet_functions.R
\name{.cronbach}
\alias{.cronbach}
\title{Bootstrap Function for \code{cronbach()} Function}
\usage{
.cronbach(dat, i, use)
}
\arguments{
\item{dat}{data.frame with only the items you wish to include in the cronbach's
alpha computation and no other variables.}

\item{i}{integer vector of length = \code{nrow(dat)} specifying which rows
should be included in the computation. When used by the \code{boot::boot} function
this argument will change with every new bootstrapped resample.}

\item{use}{character vector of length 1 specifying how missing data should be
handled when computing covariances. See \code{cov} for details.}
}
\value{
double vector of length 1 providing cronbach's alpha
}
\description{
\code{.cronbach} is the function used by the \code{\link[boot]{boot}} function
within the \code{\link{cronbach}} function. It is primarily created to increase the
computational efficiency of bootstrap confidence intervals within the
\code{cronbach} function by doing only the minimal computations needed to
compute cronbach's alpha.
}
\examples{
.cronbach(dat = attitude,
   i = sample(x = 1:nrow(attitude), size = nrow(attitude), replace = TRUE), use = "pairwise")
}
