% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{ncases}
\alias{ncases}
\title{Number of Cases in Data}
\usage{
ncases(data, vrb.nm = names(data), ov.min = 1, prop = TRUE, inclusive = TRUE)
}
\arguments{
\item{data}{data.frame or matrix of data.}

\item{vrb.nm}{a character vector of colnames from \code{data} specifying the variables.}

\item{ov.min}{minimum frequency of observed values required per row. If
\code{prop} = TRUE, then this is a decimal between 0 and 1. If \code{prop} = FALSE,
then this is a integer between 0 and \code{length(vrb.nm)}.}

\item{prop}{logical vector of length 1 specifying whether \code{ov.min} should
refer to the proportion of observed values (TRUE) or the count of observed
values (FALSE).}

\item{inclusive}{logical vector of length 1 specifying whether the case should
be included if the frequency of observed values in a row is exactly equal to \code{ov.min}.}
}
\value{
integer vector of length 1 providing the nrow in \code{data} with the given amount of observed values.
}
\description{
\code{ncases} counts how many cases in a data.frame there are that have
a specified frequency of observed values across a set of columns. This function
is similar to \code{nrow} and is essentially \code{partial.cases} + \code{sum}. The user
can have \code{ncases} return the number of complete cases by calling \code{ov.min = 1},
\code{prop = TRUE}, and \code{inclusive = TRUE} (the default).
}
\examples{
vrb_nm <- c("Ozone","Solar.R","Wind")
nrow(airquality[vrb_nm]) # number of cases regardless of missing data
sum(complete.cases(airquality[vrb_nm])) # number of complete cases
ncases(data = airquality, vrb.nm = c("Ozone","Solar.R","Wind"),
   ov.min = 2/3) # number of rows with at least 2 of the 3 variables observed
}
\seealso{
\code{\link{partial.cases}}
   \code{\link{nrow}}
}
