% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{quarto_create_project}
\alias{quarto_create_project}
\title{Create a quarto project}
\usage{
quarto_create_project(
  name,
  type = "default",
  dir = ".",
  no_prompt = FALSE,
  quiet = FALSE,
  quarto_args = NULL
)
}
\arguments{
\item{name}{The name of the project and the directory that will be created.}

\item{type}{The type of project to create. As of 1.4, it can be one of
\code{default}, \code{website}, \code{blog}, \code{book}, \code{manuscript}, \code{confluence}.}

\item{dir}{The directory where to create the new Quarto project.}

\item{no_prompt}{Do not prompt to confirm approval to download external extension.}

\item{quiet}{Suppress warning and other messages.}

\item{quarto_args}{Character vector of other \code{quarto} CLI arguments to append
to the Quarto command executed by this function. This is mainly intended for
advanced usage and useful for CLI arguments which are not yet mirrored in a
dedicated parameter of this \R function. See \verb{quarto render --help} for options.}
}
\description{
This function calls \verb{quarto create project <type> <name>}. It will create a
new directory with the project name and add some skeletons files for the
project type chosen.
}
\section{Quarto version required}{
This function require Quarto 1.4 or higher. Use \code{\link[=quarto_version]{quarto_version()}}to check
the version of Quarto detected.
}

\seealso{
Quarto documentation on \href{https://quarto.org/docs/projects/quarto-projects.html}{Quarto projects}
}
