% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{ts-models-ARCH1}
\alias{ts-models-ARCH1}
\alias{ARCH1}
\title{Simulation of an ARCH(1) time series.}
\usage{
ARCH1(n, a0, a1, overhead = 500, innov = rnorm)
}
\arguments{
\item{n}{length of the time series to be returned}

\item{a0}{parameter}

\item{a1}{parameter}

\item{overhead}{an integer specifying the ``warmup'' period to reach an
approximate stationary start for the times series}

\item{innov}{a function with one parameter \code{n} that yields \code{n}
independent pseudo random numbers each time it is called.}
}
\value{
Return an ARCH(1) time series with specified parameters.
}
\description{
Returns a simulated time series \eqn{(Y_t)} that fulfills the following equation:
\deqn{Y_t = Z_t \sigma_t, \quad \sigma_t^2 = a_0 + a_1 Y_{t-1}^2 + \epsilon_t}
where \eqn{a_0} and \eqn{a_1} are parameters and \eqn{\epsilon_t} is
independent white noise with marginal distribution specified by the
parameter \code{innov}.
}
\examples{
plot(ARCH1(100, a0=1/1.9, a1=0.9), type="l")

}
