% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossqreg.R
\name{crossqreg}
\alias{crossqreg}
\title{Cross-Quantilogram}
\usage{
crossqreg(DATA1, DATA2, vecA, k)
}
\arguments{
\item{DATA1}{An input matrix (T x p1)}

\item{DATA2}{An input matrix (T x p2)}

\item{vecA}{A pair of two probability values at which sample quantiles are estimated}

\item{k}{A lag order (integer)}
}
\value{
Cross-Quantilogram
}
\description{
Returns the cross-quantilogram
}
\details{
This function obtains the cross-quantilogram at the k lag order.
}
\examples{
## data source 
data(sys.risk)

## sample size
T = nrow(sys.risk)

## matrix for quantile regressions
## - 1st column: dependent variables
## - the rest:   regressors or predictors 
D1 = cbind(sys.risk[2:T,"Market"], sys.risk[1:(T-1),"Market"])
D2 = cbind(sys.risk[2:T,"JPM"], sys.risk[1:(T-1),"JPM"])

## probability levels
vecA = c(0.1, 0.2)

## cross-quantilogram with the lag of 5, after quantile regression 
crossqreg(D1, D2, vecA, 5)

}
\references{
Han, H., Linton, O., Oka, T., and Whang, Y. J. (2016).
"The cross-quantilogram: Measuring quantile dependence and testing directional predictability between time series."
\emph{Journal of Econometrics}, 193(1), 251-270.

Koenker, R., and Bassett Jr, G. (1978).
"Regression quantiles." \emph{Econometrica}, 46(1), 33-50.
}
\author{
Heejoon Han, Oliver Linton, Tatsushi Oka and Yoon-Jae Whang
}
