% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossq.partial.R
\name{crossq.partial}
\alias{crossq.partial}
\title{Paritial Cross-Quantilogram}
\usage{
crossq.partial(DATA, vecA, k)
}
\arguments{
\item{DATA}{A matrix}

\item{vecA}{A vector of probability values at which sample quantiles are estiamted}

\item{k}{The lag order}
}
\value{
The partial corss-quantilogram and the cross-quantilogram
}
\description{
Returns the partial cross-quantilogram
}
\details{
This function obtains the partial corss-quantilogram and the cross-quantilogram.
To obtain the partial cross-correlation given an input matrix, this function interacts
the values of the first column and the k-lagged values of the rest of the matrix.
}
\examples{
## data source 
data("sys.risk") 

## data with 3 variables 
D = sys.risk[,c("Market", "JPM", "VIX")]

## probablity levels for the 3 variables 
vecA = c(0.1, 0.1, 0.1)

## partial cross-quantilogram with the lag of 5
crossq.max.partial(D, vecA, 5)

}
\references{
Han, H., Linton, O., Oka, T., and Whang, Y. J. (2016).
"The cross-quantilogram: Measuring quantile dependence and testing directional predictability between time series." \emph{Journal of Econometrics}, 193(1), 251-270.
}
\author{
Heejoon Han, Oliver Linton, Tatsushi Oka and Yoon-Jae Whang
}
