% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textmodel_affinity.R
\name{affinity}
\alias{affinity}
\title{Internal function to fit the likelihood scaling mixture model.}
\usage{
affinity(p, x, smooth = 0.5, verbose = FALSE)
}
\arguments{
\item{p}{word likelihoods within classes, estimated from training data}

\item{x}{term-document matrix for document(s) to be scaled}

\item{smooth}{a misnamed smoothing parameter, either a scalar or a vector
equal in length to the number of documents}
}
\value{
a list with stuff
}
\description{
Ken recommends you use \code{\link{textmodel_affinity}} instead.
}
\examples{
p <- matrix(c(c(5/6, 0, 1/6), c(0, 4/5, 1/5)), nrow = 3,
            dimnames = list(c("A", "B", "C"), NULL))
theta <- c(.2, .8)
q <- drop(p \%*\% theta)
x <- 2 * q
(fit <- affinity(p, x))
}
\author{
Patrick Perry
}
\keyword{internal}
\keyword{textmodel}
