% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imageWithLabels.R
\name{imageWithLabelsNoLayout}
\alias{imageWithLabelsNoLayout}
\title{image plot with labels}
\usage{
imageWithLabelsNoLayout(x, col.labels = colnames(x),
  row.labels = rownames(x), cex = 1, cex.axis = 0.5, main = NULL,
  col = heat.colors(12), digits = 2, xlab = "", ylab = "",
  zlim = NULL, na.color = "gray", ...)
}
\arguments{
\item{x}{matrix}

\item{col.labels}{rownames(x)}

\item{row.labels}{colnames(x)}

\item{cex}{size of labels}

\item{cex.axis}{size of axis lables}

\item{main}{main title}

\item{col}{color map for matrix}

\item{digits}{number of digits on colorscale, default 2}

\item{xlab}{x label}

\item{ylab}{y label}

\item{zlim}{z value range, default NULL an determined from x}

\item{na.color}{na.color}

\item{...}{passed to image}
}
\description{
image plot with labels
}
\examples{
x = matrix(rnorm(20*30),ncol=20)
rownames(x) <- 1:30
colnames(x) <- letters[1:20]
imageWithLabelsNoLayout(x,col = heat.colors(13))
imageWithLabelsNoLayout(x,col = heat.colors(12),breaks=seq(min(x),max(x),length=13))
x[3,3] <- NA
imageWithLabelsNoLayout(x,col = heat.colors(12),
breaks=seq(min(x,na.rm=TRUE),
max(x,na.rm=TRUE),length=13))
imageWithLabelsNoLayout(x,xlab="ttt",ylab="bbb")

}

