% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_qtl.R
\name{simulate_qtl}
\alias{simulate_qtl}
\alias{print.qtlpoly.simul}
\title{Simulations of multiple QTL}
\usage{
simulate_qtl(
  data,
  mu = 0,
  h2.qtl = c(0.3, 0.2, 0.1),
  var.error = 1,
  linked = FALSE,
  n.sim = 1000,
  missing = TRUE,
  w.size = 20,
  seed = 123,
  verbose = TRUE
)

\method{print}{qtlpoly.simul}(x, detailed = FALSE, ...)
}
\arguments{
\item{data}{an object of class \code{qtlpoly.data}.}

\item{mu}{simulated phenotype mean, e.g. 0 (default).}

\item{h2.qtl}{vector with QTL heritabilities, e.g. \code{c(0.3, 0.2, 0.1)} for three QTL (default); if \code{NULL}, only error is simulated.}

\item{var.error}{simulated error variance, e.g. 1 (default).}

\item{linked}{if \code{TRUE} (default), at least two QTL will be linked; if \code{FALSE}, QTL will be randomly assigned along the genetic map. Linkage is defined by a genetic distance smaller than the selected \code{w.size}.}

\item{n.sim}{number of simulations, e.g. 1000 (default).}

\item{missing}{if \code{TRUE} (default), phenotypes are simulated with the same number of missing data observed in \code{data$pheno}.}

\item{w.size}{the window size (in centiMorgans) between two (linked) QTL, e.g. 20 (default).}

\item{seed}{integer for the \code{set.seed()} function.}

\item{verbose}{if \code{TRUE} (default), current progress is shown; if \code{FALSE}, no output is produced.}

\item{x}{an object of class \code{qtlpoly.sim} to be printed.}

\item{detailed}{if \code{TRUE}, detailed information on linkage groups and phenotypes in shown; if \code{FALSE}, no details are printed.}

\item{...}{currently ignored}
}
\value{
An object of class \code{qtlpoly.sim} which contains a list of \code{results} with the same structure of class \code{qtlpoly.data}.
}
\description{
Simulate new phenotypes with a given number of QTL and creates new object with the same structure of class \code{qtlpoly.data} from an existing genetic map.
}
\examples{
  \donttest{
  # Estimate conditional probabilities using mappoly package
  library(mappoly)
  library(qtlpoly)
  genoprob4x = lapply(maps4x[c(5)], calc_genoprob)
  data = read_data(ploidy = 4, geno.prob = genoprob4x, pheno = pheno4x, step = 1)

  # Simulate new phenotypes
  sim.dat = simulate_qtl(data = data, n.sim = 1)
  sim.dat
  }

}
\references{
Pereira GS, Gemenet DC, Mollinari M, Olukolu BA, Wood JC, Mosquera V, Gruneberg WJ, Khan A, Buell CR, Yencho GC, Zeng ZB (2020) Multiple QTL mapping in autopolyploids: a random-effect model approach with application in a hexaploid sweetpotato full-sib population, \emph{Genetics} 215 (3): 579-595. \doi{10.1534/genetics.120.303080}.
}
\seealso{
\code{\link[qtlpoly]{read_data}}
}
\author{
Guilherme da Silva Pereira, \email{gdasilv@ncsu.edu}
}
