% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scat2scat.R
\name{scat2scat}
\alias{scat2scat}
\title{Scatterplot driving another scatterplot}
\usage{
scat2scat(scat1data, scat2data, group = NULL, chartOpts = NULL,
  digits = 5)
}
\arguments{
\item{scat1data}{Matrix with two columns; rownames are used as
identifiers. Can have an optional third column with categories for
coloring points in the first scatterplot (to be used if
\code{group} is not provided).}

\item{scat2data}{List of matrices each with at least two columns,
to be shown in the second scatterplot. The components of the list
correspond to the rows in \code{scat1dat}. An option third column
can contain categories. Row names identify individual points.}

\item{group}{Categories for coloring points in the first
scatterplot; length should be the number of rows in
\code{scat1data}.}

\item{chartOpts}{A list of options for configuring the chart.  Each
element must be named using the corresponding option.}

\item{digits}{Round data to this number of significant digits
before passing to the chart function. (Use NULL to not round.)}
}
\value{
An object of class \code{htmlwidget} that will
intelligently print itself into HTML in a variety of contexts
including the R console, within R Markdown documents, and within
Shiny output bindings.
}
\description{
A pair of linked scatterplots, where each point the first
scatterplot corresponds to a scatter of points in the second
scatterplot. The first scatterplot corresponds to a pair of summary
measures for a larger dataset.
}
\examples{
# simulate some data
p <- 500
n <- 300
SD <- runif(p, 1, 5)
r <- runif(p, -1, 1)
scat2 <- vector("list", p)
for(i in 1:p)
   scat2[[i]] <- matrix(rnorm(2*n), ncol=2) \%*\% chol(SD[i]^2*matrix(c(1, r[i], r[i], 1), ncol=2))
scat1 <- cbind(SD=SD, r=r)
# plot it
scat2scat(scat1, scat2)

}
\seealso{
\code{\link{iplotCorr}}
}
\keyword{hplot}
