% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iplotScantwo.R
\name{iplotScantwo}
\alias{iplotScantwo}
\title{Interactive plot of 2d genome scan}
\usage{
iplotScantwo(scantwoOutput, cross = NULL, lodcolumn = 1, pheno.col = 1,
  chr = NULL, chartOpts = NULL, digits = 5)
}
\arguments{
\item{scantwoOutput}{Output of \code{\link[qtl]{scantwo}}}

\item{cross}{(Optional) Object of class \code{"cross"}, see
\code{\link[qtl]{read.cross}}.}

\item{lodcolumn}{Numeric value indicating LOD score column to plot.}

\item{pheno.col}{(Optional) Phenotype column in cross object.}

\item{chr}{(Optional) Optional vector indicating the chromosomes
for which LOD scores should be calculated. This should be a vector
of character strings referring to chromosomes by name; numeric
values are converted to strings. Refer to chromosomes with a
preceding - to have all chromosomes but those considered. A logical
(TRUE/FALSE) vector may also be used.}

\item{chartOpts}{A list of options for configuring the chart.  Each
element must be named using the corresponding option.}

\item{digits}{Round data to this number of significant digits
before passing to the chart function. (Use NULL to not round.)}
}
\value{
An object of class \code{htmlwidget} that will
intelligently print itself into HTML in a variety of contexts
including the R console, within R Markdown documents, and within
Shiny output bindings.
}
\description{
Creates an interactive plot of the results of
\code{\link[qtl]{scantwo}}, for a two-dimensional, two-QTL genome
scan.
}
\details{
The estimated QTL effects, and the genotypes in the
phenotype x genotype plot, in the right-hand panels, are derived
following a single imputation to fill in missing data, and so are a
bit crude.

Note that the usual \code{height} and \code{width} options in
\code{chartOpts} are ignored here. Instead, you may provide
\code{pixelPerCell} (number of pixels per cell in the heat map),
\code{chrGap} (gaps between chr in heat map), \code{wright} (width
in pixels of right panels), and \code{hbot} (height in pixels of
each of the lower panels)
}
\examples{
library(qtl)
data(fake.f2)
\dontshow{fake.f2 <- fake.f2[c(1, 13, "X"),]}
fake.f2 <- calc.genoprob(fake.f2, step=5)
out <- scantwo(fake.f2, method="hk", verbose=FALSE)
\donttest{
iplotScantwo(out, fake.f2)}

}
\seealso{
\code{\link{iplotScanone}}
}
\keyword{hplot}
