% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_x_covar.R
\name{get_x_covar}
\alias{get_x_covar}
\title{Get X chromosome covariates}
\usage{
get_x_covar(cross)
}
\arguments{
\item{cross}{Object of class \code{"cross2"}. For details, see the
\href{https://kbroman.org/qtl2/assets/vignettes/developer_guide.html}{R/qtl2 developer guide}.}
}
\value{
A matrix of size individuals x no. covariates.
}
\description{
Get the matrix of covariates to be used for the null hypothesis when
performing QTL analysis with the X chromosome.
}
\details{
For most crosses, the result is either \code{NULL}
(indicating no additional covariates are needed) or a
matrix with a single column containing sex indicators (1 for males
and 0 for females).

For an intercross, we also consider cross direction. There are
four cases: (1) All male or all female but just one direction: no
covariate; (2) All female but both directions: covariate indicating
cross direction; (3) Both sexes, one direction: covariate
indicating sex; (4) Both sexes, both directions: a covariate
indicating sex and a covariate that is 1 for females from the
reverse direction and 0 otherwise.
}
\examples{
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
xcovar <- get_x_covar(iron)
}
\keyword{utilities}
