% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcbind_scan1perm.R
\name{cbind.scan1perm}
\alias{cbind.scan1perm}
\title{Combine columns from multiple scan1 permutation results}
\usage{
\method{cbind}{scan1perm}(...)
}
\arguments{
\item{...}{A set of permutation results from
\code{\link[=scan1perm]{scan1perm()}} (objects of class \code{"scan1perm"}. If
different numbers of permutation replicates were used, those
columns with fewer replicates are padded with missing values
\code{NA}. However, if any include autosome/X
chromosome-specific permutations, they must all be such.}
}
\value{
The combined column-binded input, as an object of class \code{"scan1perm"}; see \code{\link[=scan1perm]{scan1perm()}}.
}
\description{
Column-bind multiple scan1perm objects with the same numbers of rows.
}
\details{
The aim of this function is to concatenate the results
from multiple runs of a permutation test with
\code{\link[=scan1perm]{scan1perm()}}, generally with different phenotypes
and/or methods, to be used in parallel with
\code{\link[=rbind.scan1perm]{rbind.scan1perm()}}.
}
\examples{
# read data
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
\dontshow{iron <- iron[,c("19","X")] # subset to chr 19 and X}

# insert pseudomarkers into map
map <- insert_pseudomarkers(iron$gmap, step=1)

# calculate genotype probabilities
probs <- calc_genoprob(iron, map, error_prob=0.002)

# grab phenotypes and covariates; ensure that covariates have names attribute
pheno <- iron$pheno
covar <- match(iron$covar$sex, c("f", "m")) # make numeric
names(covar) <- rownames(iron$covar)
Xcovar <- get_x_covar(iron)

# permutations with genome scan (just 3 replicates, for illustration)
operm1 <- scan1perm(probs, pheno[,1,drop=FALSE], addcovar=covar, Xcovar=Xcovar, n_perm=3)
operm2 <- scan1perm(probs, pheno[,2,drop=FALSE], addcovar=covar, Xcovar=Xcovar, n_perm=3)

operm <- cbind(operm1, operm2)

}
\seealso{
\code{\link[=rbind.scan1perm]{rbind.scan1perm()}}, \code{\link[=scan1perm]{scan1perm()}}, \code{\link[=scan1]{scan1()}}
}
