% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sdp.R
\name{plot_sdp}
\alias{plot_sdp}
\title{plot strain distribution patterns for SNPs}
\usage{
plot_sdp(pos, sdp, strain_labels = names(qtl2::CCcolors), ...)
}
\arguments{
\item{pos}{vector of SNP positions}

\item{sdp}{vector of strain distribution patterns (as integers)}

\item{strain_labels}{names of the strains}

\item{...}{additional graphic arguments}
}
\value{
None.
}
\description{
plot the strain distribution patterns of SNPs
using tracks of tick-marks for each founder strain
}
\details{
Additional arguments, such as \code{xlab}, \code{ylab}, \code{xlim}, and \code{main},
are passed via \code{...}; also \code{bgcolor} to control the color of the
background, and \code{col} and \code{lwd} to control the color and thickness
of the tick marks.
}
\examples{
n_tick <- 50
plot_sdp(runif(n_tick, 0, 100), sample(0:255, n_tick, replace=TRUE))
}
\seealso{
\code{\link[=calc_sdp]{calc_sdp()}}, \code{\link[=invert_sdp]{invert_sdp()}}
}
\keyword{hgraphics}
