% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_scan1perm.R
\name{print.summary.scan1perm}
\alias{print.summary.scan1perm}
\title{Print summary of scan1perm permutations}
\usage{
\method{print}{summary.scan1perm}(x, digits = 3, ...)
}
\arguments{
\item{x}{Object of class \code{"summary.scan1perm"}, as produced by \code{\link[=summary_scan1perm]{summary_scan1perm()}}.}

\item{digits}{Number of digits in printing significance thresholds; passed to \code{\link[base:print]{base::print()}}.}

\item{...}{Ignored.}
}
\value{
Invisibly returns the input, \code{x}.
}
\description{
Print summary of scan1perm permutations
}
\details{
This is to go with \code{\link[=summary_scan1perm]{summary_scan1perm()}}, so
that the summary output is printed in a nice format. Generally
not called directly, but it can be in order to control the
number of digits that appear.
}
\examples{
# read data
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
\dontshow{iron <- iron[,c(10,18,"X")]}

# insert pseudomarkers into map
map <- insert_pseudomarkers(iron$gmap, step=1)

# calculate genotype probabilities
probs <- calc_genoprob(iron, map, error_prob=0.002)

# grab phenotypes and covariates; ensure that covariates have names attribute
pheno <- iron$pheno
covar <- match(iron$covar$sex, c("f", "m")) # make numeric
names(covar) <- rownames(iron$covar)
Xcovar <- get_x_covar(iron)

# permutations with genome scan (just 3 replicates, for illustration)
operm <- scan1perm(probs, pheno, addcovar=covar, Xcovar=Xcovar,
                   n_perm=3)

print( summary(operm, alpha=c(0.20, 0.05)), digits=8 )

}
