% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_kinship.R
\name{calc_kinship}
\alias{calc_kinship}
\title{Calculate kinship matrix}
\usage{
calc_kinship(
  probs,
  type = c("overall", "loco", "chr"),
  omit_x = FALSE,
  use_allele_probs = TRUE,
  quiet = TRUE,
  cores = 1
)
}
\arguments{
\item{probs}{Genotype probabilities, as calculated from
\code{\link[=calc_genoprob]{calc_genoprob()}}.}

\item{type}{Indicates whether to calculate the overall kinship
(\code{"overall"}, using all chromosomes), the kinship matrix
leaving out one chromosome at a time (\code{"loco"}), or the
kinship matrix for each chromosome (\code{"chr"}).}

\item{omit_x}{If \code{TRUE}, only use the autosomes; ignored when
\code{type="chr"}.}

\item{use_allele_probs}{If \code{TRUE}, assess similarity with
allele probabilities (that is, first run
\code{\link[=genoprob_to_alleleprob]{genoprob_to_alleleprob()}}); otherwise use the genotype
probabilities.}

\item{quiet}{IF \code{FALSE}, print progress messages.}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}
}
\value{
If \code{type="overall"} (the default), a matrix of
proportion of matching alleles. Otherwise a list with one matrix
per chromosome.
}
\description{
Calculate genetic similarity among individuals (kinship matrix)
from conditional genotype probabilities.
}
\details{
If \code{use_allele_probs=TRUE} (the default), we first
convert the genotype probabilities are converted to allele
probabilities (using \code{\link[=genoprob_to_alleleprob]{genoprob_to_alleleprob()}}). This is
recommended, as then the result is twice the empirical kinship
coefficient (e.g., the expected value for an intercross is 1/2;
using genotype probabilities, the expected value is 3/8).

We then calculate
\eqn{\sum_{kl}(p_{ikl} p_{jkl})}{sum_kl (p_ikl p_jkl)}
where \eqn{k} = position, \eqn{l} = allele, and \eqn{i,j}
are two individuals.

For crosses with just two possible genotypes (e.g., backcross), we
don't convert to allele probabilities but just use the original
genotype probabilities.
}
\examples{
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
map <- insert_pseudomarkers(grav2$gmap, step=1)
probs <- calc_genoprob(grav2, map, error_prob=0.002)
K <- calc_kinship(probs)

# using only markers/pseudomarkers on the grid
grid <- calc_grid(grav2$gmap, step=1)
probs_sub <- probs_to_grid(probs, grid)
K_grid <- calc_kinship(probs_sub)
}
\keyword{utilities}
