% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_kbl.R
\name{write_kbl}
\alias{write_kbl}
\title{Write a kable object to a file}
\usage{
write_kbl(
  kbl_obj,
  file = NULL,
  target_dir = NULL,
  device = "pdf",
  bs_theme = "bootstrap",
  ...
)
}
\arguments{
\item{kbl_obj}{The knitr_kable object to be written.}

\item{file}{The name of the file to be written. If not specified,
the name will be based on the current knitr code block label.}

\item{target_dir}{The directory where the file will be written. If not
specified, the current working directory will be used.}

\item{device}{The device to be used for saving the file. Options
include "pdf" (default), "html", "latex", "png", and "jpeg". Note that
a Chromium-based browser (e.g., Google Chrome, Chromium, Microsoft Edge or
Brave) is required on your system for all options except "latex'. If a
suitable browser is not available, the function will stop and return an
error message.}

\item{bs_theme}{The Bootstrap theme to be applied to the kable object
(only applicable for HTML output). Default is "bootstrap".}

\item{...}{Additional arguments to be passed to the \code{save_kable}
function from the \code{kableExtra} package.}
}
\value{
The path of the written file.
}
\description{
A wrapper around \code{kableExtra::save_kable} that facilitates saving kable objects
within knitr documents. Automatically handles file naming, directory creation,
and supports multiple output formats with Bootstrap theming options.
}
\details{
The function extends \code{save_kable} functionality by:
\itemize{
\item Using knitr code block labels for automatic file naming
\item Creating target directories if they don't exist
\item Supporting multiple output formats (PDF, HTML, LaTeX, PNG, JPEG)
\item Applying Bootstrap themes for HTML output
\item Preserving table styling and formatting
}

For HTML output, the function supports all Bootstrap themes available in
kableExtra. The default theme is "bootstrap".
}
\examples{
\dontrun{
library(knitr)

table_dir <- file.path(tempdir(), "table")

mtcars_kbl <- kable(
  x = mtcars[1:5, ],
  format = "html"
)

# Write a kable object as a PDF file
write_kbl(
  kbl_obj = mtcars_kbl,
  file = "kable_pdf",
  target_dir = table_dir,
  device = "pdf"
)

# Write a kable as an HTML file with a custom Bootstrap theme
write_kbl(
  kbl_obj = mtcars_kbl,
  file = "kable_html",
  target_dir = table_dir,
  device = "html",
  bs_theme = "flatly"
)

unlink(table_dir)
}
}
\keyword{publishing}
