% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\name{qs_save}
\alias{qs_save}
\title{qs_save}
\usage{
qs_save(object, file, compress_level = 3L,
shuffle = TRUE, nthreads = 1L)
}
\arguments{
\item{object}{The object to save.}

\item{file}{The file name/path.}

\item{compress_level}{The compression level used (default 3).

The maximum and minimum possible values depends on the version of ZSTD library used.
As of ZSTD 1.5.6 the maximum compression level is 22, and the minimum is -131072. Usually, values in the low positive range offer very good performance in terms
of speed and compression.}

\item{shuffle}{Whether to allow byte shuffling when compressing data (default: \code{TRUE}).}

\item{nthreads}{The number of threads to use when compressing data (default: \code{1}).}
}
\value{
No value is returned. The file is written to disk.
}
\description{
Saves an object to disk using the \code{qs2} format.
}
\examples{
x <- data.frame(int = sample(1e3, replace=TRUE),
        num = rnorm(1e3),
        char = sample(state.name, 1e3, replace=TRUE),
         stringsAsFactors = FALSE)
myfile <- tempfile()
qs_save(x, myfile)
x2 <- qs_read(myfile)
identical(x, x2) # returns true

# qs2 support multithreading
qs_save(x, myfile, nthreads=1)
x2 <- qs_read(myfile, nthreads=1)
identical(x, x2) # returns true
}
