% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qr_logo.R
\name{qr_logo}
\alias{qr_logo}
\title{Generate QR code with a logo on top}
\usage{
qr_logo(
  x,
  logo,
  filename,
  size = 300,
  foreground = "black",
  background = "white",
  show = interactive()
)
}
\arguments{
\item{x}{the input string}

\item{logo}{the path to a logo image file}

\item{filename}{Where to store the QR code as svg file.
Silently overwrites existing files.
Tries to create the path, when it doesn't exist.}

\item{size}{width of the svg file in pixels.
Defaults to \code{300}.}

\item{foreground}{Stroke and fill colour for the foreground.
Use a valid \href{https://www.w3schools.com/colors/}{CSS colour}.
Defaults to \code{"black"}.}

\item{background}{Fill colour for the background.
Use a valid \href{https://www.w3schools.com/colors/}{CSS colour}.
Defaults to \code{"white"}.}

\item{show}{Open the file after creating it.
Defaults to \code{TRUE} on \code{\link[=interactive]{interactive()}} sessions, otherwise \code{FALSE}.}
}
\description{
Will create an \code{svg} file with the QR code and logo.
}
