% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariance.R
\name{getQLmodel}
\alias{getQLmodel}
\title{Setup the quasi-likelihood approximation model all at once}
\usage{
getQLmodel(runs, lb, ub, obs, X = NULL, useVar = TRUE,
  criterion = "qle", ...)
}
\arguments{
\item{runs}{object of class \code{simQL}, simulation results from \code{\link{simQLdata}}}

\item{lb}{lower bounds defining the (hyper)box of the parameter domain for QL estimation}

\item{ub}{upper bounds defining the (hyper)box of the parameter domain for QL estimation}

\item{obs}{numeric vector of observed statistics}

\item{X}{matrix of sample locations (model parameters)}

\item{useVar}{logical, \code{TRUE} (default), whether to use prediction variances of any kind}

\item{criterion}{name of criterion function to be minimized for QL estimation (see \code{\link{qle}})}

\item{...}{arguments passed to \code{\link{fitSIRFk}}, \code{\link{setQLdata}}, \code{\link{setCovModel}} 
and \code{\link{QLmodel}} for REML estimation of all covariance models}
}
\value{
Object of class \code{\link{QLmodel}}
}
\description{
Initial setup of the quasi-likelihood approximation model
}
\details{
The function is a wrapper of \code{\link{simQLdata}}, \code{\link{QLmodel}}, \code{\link{fitSIRFk}}
 and thus sets up the quasi-likelihood approximation model all at once.
}
\examples{

data(normal)

# simulate model at a minimum of required design points
sim <- simQLdata(sim=qsd$simfn,nsim=5,N=8,
			 method="maximinLHS",lb=qsd$lower,ub=qsd$upper)
	 
# true and error-free observation
obs <- structure(c("T1"=2,"T2"=1), class="simQL")

# construct QL approximation model
qsd <- getQLmodel(sim,qsd$lower,qsd$upper,obs,var.type="wcholMean")


}
\seealso{
\code{\link{simQLdata}}, \code{\link{QLmodel}}, \code{\link{fitSIRFk}}
}
\author{
M. Baaske
}
