% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag.r
\name{qiita_tag}
\alias{qiita_follow_tag}
\alias{qiita_get_tags}
\alias{qiita_is_following_tag}
\alias{qiita_tag}
\alias{qiita_unfollow_tag}
\title{Qiita Tag API}
\usage{
qiita_get_tags(tag_id = NULL, user_id = NULL, per_page = 100L,
  page_offset = 0L, page_limit = 1L)

qiita_follow_tag(tag_id)

qiita_unfollow_tag(tag_id)

qiita_is_following_tag(tag_id)
}
\arguments{
\item{tag_id}{Tag ID (e.g. \code{"R"}, \code{"dplyr"}).}

\item{user_id}{User ID (e.g. \code{"yutannihilation"}).}

\item{per_page}{Number of items per one page.}

\item{page_offset}{Page offset.}

\item{page_limit}{Max number of pages to aquire.}
}
\description{
Get, follow or unfollow tags via Qiita API.
}
\examples{
\dontrun{
# get a tag by Tag IDs
qiita_get_tags(tag_id = "R")

# get tags by user ID
qiita_get_tags(user_id = "yutannihilation")

# follow a tag
qiita_follow_tag("RStudio")

# unfollow a tag
qiita_unfollow_tag("RStudio")
}
}

