% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_statistics.R
\name{adjLDStat}
\alias{adjLDStat}
\title{Check concordance between marker effect and sparse LD matrix.}
\usage{
adjLDStat(
  stat = NULL,
  Glist = NULL,
  chr = NULL,
  region = NULL,
  msize = NULL,
  threshold = 1e-05,
  overlap = NULL,
  niter = 5
)
}
\arguments{
\item{stat}{data frame with marker summary statistics (see required format above)}

\item{Glist}{list of information about genotype matrix stored on disk}

\item{chr}{chromosome for which marker effect is checked}

\item{region}{genome region (in base pairs) for which marker effect is checked}

\item{msize}{is the number of markers used in the prediction}

\item{threshold}{p-value threshold used for chisquare test for difference between observed and predicted marker effects}

\item{overlap}{is the number of markers overlapping between adjacent genome region}

\item{niter}{is the number of iteration used for detecting outliers}
}
\description{
Check concordance between predicted and observed marker effect. Marker effect is predicted based on sparse LD matrix in Glist.
}
\keyword{internal}
