% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig_scale.R
\name{sig_scale}
\alias{sig_scale}
\title{Scale fatty acid signature proportions}
\usage{
sig_scale(sig_data, fa_use, scale = 3)
}
\arguments{
\item{sig_data}{A numeric matrix containing prey signature data as
proportions in column-major.  These data should have previously been
processed by \code{\link{sig_rep_zero}}.}

\item{fa_use}{A logical vector denoting the fatty acids to be used, of length
equal to the total number of fatty acids. This vector originates from a
data file required by \code{qfasar}. See the vignette for details.}

\item{scale}{An integer indicator of the desired scaling option. See
Details. Default value 3.}
}
\value{
A list containing the following elements: \describe{
  \item{n_fa}{The number of fatty acids in the processed signatures.}
  \item{sig}{A numeric matrix of processed signatures in column-major
    format.}
  \item{err_code}{An integer error code (0 if no error is detected).}
  \item{err_message}{A string contains a brief summary of the execution.}
  }
}
\description{
The utility function \code{sig_scale} implements the three options for
scaling fatty acid signature data summarized by Bromaghin et al. (2016).
A logical vector denotes the subset of all fatty acids to be used in the
analysis.  The fatty acids that are not to be used are censored and one of
three scaling options is implemented.  See Details.
}
\section{Details}{

This is an internal utility function.

The argument \code{scale} must be one of three integer values and its value
denotes the scaling option that will be implemented:\itemize{
  \item \code{scale} == 1.  The proportions within each censored signature
    are scaled to sum to 1.0.  This option is not recommended for routine
    use in QFASA applications, as Bromaghin et al. (2016) found that it
    can meaningfully bias diet estimates under some conditions.  It is
    implemented here to provide compatibility with original methods and to
    facilitate potential future research.
  \item \code{scale} == 2.  The proportions within each censored signature
    are not scaled, so each signature will have a different partial sum.
  \item \code{scale} == 3.  Each censored signature is augmented with an
    additional proportion whose value equals the sum of the censored
    proportions, so that the proportions in each signature sum to 1.
    This is the default option.
  }
}

\section{References}{

Bromaghin, J.F., S.M. Budge, and G.W. Thiemann. 2016. Should fatty
  acid signature proportions sum to 1 for diet estimation?
  \emph{Ecological Research} 31:597-606.
}

