% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/explain.R
\name{explain}
\alias{explain}
\title{Visualize Regular Expressions}
\usage{
explain(pattern, open = FALSE, print = TRUE,
  dictionary = getOption("regex.library"))
}
\arguments{
\item{pattern}{A character string containing a regular expression or a
character string starting with \code{"@"} that is a regular
expression from a \pkg{qdapRegex} dictionary.}

\item{open}{logical.  If \code{TRUE} the default browser will attempt to
open \url{http://www.regexper.com} page.  Setting \code{open = 2} will
utilize an unstable visualization via \url{https://www.debuggex.com}.  This
approach utilizes a non-api scrape that is subject to change and not
guaranteed to be stable.  The regex is set to Python flavor which handles
lookbehinds that the Java based \url{http://www.regexper.com} does not.  This
functionality was developed by
\href{http://www.matthewflickinger.com}{Matthew Flickinger} (see
\url{http://stackoverflow.com/a/27574103/1000343} for details).  Note that
the user must have \pkg{httr} installed or will be prompted if the package
cannot be \code{\link[base]{require}}d.}

\item{print}{logical.  Should \code{explain} print output to the console?}

\item{dictionary}{A dictionary of canned regular expressions to search within.}
}
\value{
Prints \url{http://rick.measham.id.au/paste/explain} to the console,
attempts to open the url to the visual representation provided by
\url{http://www.regexper.com}, and invisibly returns a list with the URLs.
}
\description{
Visualize regular expressions using \url{http://www.regexper.com} &
\url{http://rick.measham.id.au/paste/explain}.
}
\details{
Note that \url{http://www.regexper.com} is a Java based regular
expression viewer. Lookbehind and negative lookbehinds are not respected.
}
\examples{
explain("\\\\s*foo[A-Z]\\\\d{2,3}")
explain("@rm_time")
\dontrun{
explain("\\\\s*foo[A-Z]\\\\d{2,3}", open = TRUE)
explain("@rm_time", open = TRUE)
}
}
\author{
Ananda Mahto, Matthew Flickinger, and Tyler Rinker <tyler.rinker@gmail.com>.
}
\references{
\url{http://stackoverflow.com/a/27489977/1000343} \cr
\url{http://www.regexper.com} \cr
\url{http://rick.measham.id.au/paste/explain} \cr
\url{http://stackoverflow.com/a/27574103/1000343}
}
\seealso{
\url{http://www.regexper.com} \cr
\url{http://rick.measham.id.au/paste/explain}
}
\keyword{explain}
\keyword{regex}

