% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_number.R
\name{replace_number}
\alias{replace_number}
\title{Replace Numbers With Text Representation}
\usage{
replace_number(text.var, num.paste = TRUE, remove = FALSE)
}
\arguments{
\item{text.var}{The text variable.}

\item{num.paste}{logical.  If \code{TRUE} a the elements of larger numbers are 
separated with spaces.  If \code{FALSE} the elements will be joined without 
spaces.}

\item{remove}{logical.  If \code{TRUE} numbers are removed from the text.}
}
\value{
Returns a vector with abbreviations replaced.
}
\description{
Replaces numeric represented numbers with words (e.g., 1001 becomes one 
thousand one).
}
\note{
The user may want to use \code{\link[qdap]{replace_ordinal}} first to 
remove ordinal number notation.  For example \code{\link[qdap]{replace_number}}
would turn "21st" into "twenty onest", whereas \code{\link[qdap]{replace_ordinal}}
would generate "twenty first".
}
\examples{
\dontrun{
x <- c("I like 346,457 ice cream cones.", "They are 99 percent good")
y <- c("I like 346457 ice cream cones.", "They are 99 percent good")
replace_number(x)
replace_number(y)
replace_number(x, FALSE)
replace_number(x, remove=TRUE)
}
}
\references{
Fox, J. (2005). Programmer's niche: How do you spell that number? 
R News. Vol. 5(1), pp. 51-55.
}
\seealso{
\code{\link[qdap]{bracketX}},
\code{\link[qdap]{qprep}},
\code{\link[qdap]{replace_abbreviation}},
\code{\link[qdap]{replace_contraction}},
\code{\link[qdap]{replace_symbol}},
\code{\link[qdap]{replace_ordinal}}
}
\keyword{number-to-word}

