% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qad.R
\name{pairwise.qad}
\alias{pairwise.qad}
\title{Pairwise measures of (asymmetric) dependencies}
\usage{
pairwise.qad(
  data_df,
  resolution = NULL,
  permutation = FALSE,
  nperm = 10,
  DoParallel = TRUE,
  registerC = registerDoParallel,
  ncores = NULL
)
}
\arguments{
\item{data_df}{a data frame containing numeric columns with the observations of the sample.}

\item{resolution}{an integer indicating the number of strips for the checkerboard aggregation (see \link{emp_c_copula}()).
Default (NULL) uses the optimal resolution, computed out of the sample size.}

\item{permutation}{a logical indicating whether a permutated p-value is computed.}

\item{nperm}{an integer indicating the number of permutation runs.}

\item{DoParallel}{a logical value indicating whether the permutation test is computed parallelized.}

\item{registerC}{function to register the parallel backend. It is recommended to use registerDoParallel() of the doParallel package (default). Other option is for example on a linux based system to install the
doMC package and use registerDoMC}

\item{ncores}{an integer indicating the number of cores used for parallelization. Default (NULL) uses the maximum number of cores minus 1.}
}
\value{
a list, containing 6 data.frames with the dependence measures and corresponding p.values.
The output of pairwise.qad can be illustrated with the function \code{heatmap.qad()}.
}
\description{
Pairwise computation of the function \code{qad}(). \code{qad}() is applied on each pair of variables of a numeric data.frame.
}
\examples{
n <- 100
x <- runif(n, 0, 1)
y <- runif(n, 0, 1)
z <- runif(n, 0, 1)
sample_df <- data.frame(x,y,z)

#qad (Not Run)
#model <- pairwise.qad(sample_df, permutation = TRUE, nperm = 20, DoParallel = TRUE)
#heatmap.qad(model, select = "dependence", fontsize = 20, significance = TRUE)
}
