% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMARC.R
\name{rcbaModel2CBARuleModel}
\alias{rcbaModel2CBARuleModel}
\title{rcbaModel2arcCBARuleModel Converts a model created by \pkg{rCBA} so that it can be passed to qCBA}
\usage{
rcbaModel2CBARuleModel(rcbaModel, cutPoints, rawDataset, classAtt, attTypes)
}
\arguments{
\item{rcbaModel}{object returned  by rCBA::build}

\item{cutPoints}{specification of cutpoints applied on the data before they were passed to  \code{rCBA::build}}

\item{rawDataset}{the raw data (before discretization). This dataset is used to guess attribute types if attTypes is not passed}

\item{classAtt}{the name of the class attribute}

\item{attTypes}{vector of attribute types of the original data.  If set to null, you need to pass rawDataset.}
}
\description{
Creates instance of CBAmodel class from the \pkg{arc} package
Instance of CBAmodel can then be passed to \link{qcba}
}
\examples{
# this example takes about 10 seconds
if (! requireNamespace("rCBA", quietly = TRUE)) {
 message("Please install rCBA: install.packages('rCBA')")
} else
{
# This will run only outside a CRAN test, if the environment variable  NOT_CRAN is set to true
# This environment variable is set by devtools
if (identical(Sys.getenv("NOT_CRAN"), "true")) {
\dontrun{
 library(rCBA)
 message(packageVersion("rCBA"))
 discrModel <- discrNumeric(iris, "Species")
 irisDisc <- as.data.frame(lapply(discrModel$Disc.data, as.factor))
 
 rCBAmodel <- rCBA::build(irisDisc,parallel=FALSE, sa=list(timeout=0.01))
 CBAmodel <- rcbaModel2CBARuleModel(rCBAmodel,discrModel$cutp,iris,"Species")
 qCBAmodel <- qcba(CBAmodel,iris)
 print(qCBAmodel@rules)
 }
 }
}


}
