/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.pipeline;

import eu.kliegr.ac1.AC1;
import eu.kliegr.ac1.PipelineConfig;
import eu.kliegr.ac1.pipeline.PipelineStep;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.logging.Logger;

public class Experimentator {
    private static final Logger LOGGER = Logger.getLogger(Experimentator.class.getName());

    public static void runPipeline(PipelineConfig config) throws IOException, InterruptedException, Exception {
        for (PipelineStep step : config.pipelineStep) {
            if (step.getReplacementParam() != null) {
                String content = new String(Files.readAllBytes(Paths.get(step.getFilename(), new String[0])), StandardCharsets.UTF_8);
                int i = 0;
                for (String replacement : step.getReplacementParam().getReplacements()) {
                    if (step.getReplacementParam().getSkips().get(i).booleanValue()) {
                        ++i;
                        continue;
                    }
                    ++i;
                    String replacedContent = content.replaceAll(step.getReplacementParam().getReplaceregex(), replacement);
                    String outputfilename = step.getOutputfilename(step.getReplacementParam().getName(), replacement);
                    Files.write(Paths.get(outputfilename, new String[0]), replacedContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    Experimentator.executeStep(outputfilename);
                }
                continue;
            }
            Experimentator.executeStep(step.getFilename());
        }
    }

    private static void executeStep(String outputfilename) throws Exception {
        AC1.main(new String[]{outputfilename});
        AC1.cleanup();
    }

    private Experimentator() {
    }
}

