% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_variable1.R
\name{px_contvariable}
\alias{px_contvariable}
\alias{px_contvariable.px}
\title{CONTVARIABLE}
\usage{
px_contvariable(x, value, validate)

\method{px_contvariable}{px}(x, value, validate = TRUE)
}
\arguments{
\item{x}{A px object}

\item{value}{Optional. A character string. If missing, the current CONTVARIABLE is returned. If NULL, CONTVARIABLE is removed.}

\item{validate}{Optional. If TRUE a number of validation checks are performed on the px object, and an error is thrown if the object is not valid. If FALSE, the checks are skipped, which can be usefull for large px objects where the check can be time consuming. Use \code{\link[=px_validate]{px_validate()}} to manually preform the check.}
}
\value{
A px object or a character string.
}
\description{
Inspect or change CONTVARIABLE.

Setting CONTVARIABLE indexes several variables in table2.
Removing CONTVARIABLE removes the indexing from table2.
}
\examples{
# Set CONTVARIABLE
x1 <-
  px(population_gl) |>
  px_contvariable('gender')

# After setting CONTVARIABLE some variables are index by it, e.g. UNITS
px_units(x1)

# Remove CONTVARIABLE
x2 <- px_contvariable(x1, NULL)
px_contvariable(x2)

# Removing CONTVARIABLE also removes the index from UNITS
px_units(x2)
}
\seealso{
\href{https://www.scb.se/globalassets/vara-tjanster/px-programmen/px-file_format_specification_2013.pdf#\%5B\%7B\%22num\%22\%3A42\%2C\%22gen\%22\%3A0\%7D\%2C\%7B\%22name\%22\%3A\%22XYZ\%22\%7D\%2C184\%2C484\%2C0\%5D}{Statistics Sweden's documentation}
}
