% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varx.R
\name{as.varx}
\alias{as.varx}
\title{Coerce into a '\code{varx}' object}
\usage{
as.varx(x, ...)
}
\arguments{
\item{x}{A VAR object to be transformed.}

\item{...}{Additional arguments to be passed to or from methods.}
}
\value{
A list of class '\code{varx}'. Objects of this class contain the elements:
\item{A}{Matrix. The lined-up VAR coefficient matrices \eqn{A_j, j=1,\ldots,p} for the 
  lagged variables.}
\item{B}{Matrix. The \eqn{(K \times S)} structural impact matrix of the SVAR model 
  or an identity matrix \eqn{I_K} as a placeholder for the unidentified VAR model.}
\item{SIGMA}{Matrix. The \eqn{(K \times K)} residual covariance matrix estimated by least-squares.}
  The following integers indicate the size of dimensions:
\item{dim_K}{Integer. The number of endogenous variables \eqn{K} in the full-system.}
\item{dim_S}{Integer. The number of identified shocks \eqn{S} in the SVAR model.}
\item{dim_T}{Integer. The number of time periods \eqn{T} without presample.}
\item{dim_p}{Integer. The lag-order \eqn{p} of the VAR model in levels.}
\item{dim_r}{Integer. The cointegration rank \eqn{r} of the VAR model
  if transformed from a rank-restricted VECM.}
  Some further elements required for the bootstrap functions are: 
\item{y}{Matrix. The \eqn{(K \times (p+T))} endogenous variables.}
\item{D,D1,D2}{Matrices. The \eqn{(n_{\bullet} \times (p+T))}
  deterministic variables, fixed over bootstrap iterations, 
  (un)restricted to the cointegration relations of the VAR model 
  if transformed from a rank-restricted VECM.}
\item{resid}{Matrix. The \eqn{(K \times T)} residual matrix.}
\item{beta}{Matrix. The \eqn{((K+n_{d1}) \times r)} cointegrating matrix of the VAR model 
  if transformed from a rank-restricted VECM.}
\item{args_id}{List of characters and integers indicating the identification 
  methods and specifications that have been used. This element is specific 
  to the child-class '\code{id}' for SVAR models, that inherit from
  parent-class '\code{varx}' for any VAR model.}
}
\description{
Coerce into a '\code{varx}' object. On top of the parent class 
  '\code{varx}', the child class '\code{id}' is imposed if the input object 
  to be transformed contains an SVAR model.
}
\details{
\code{\link{as.varx}} is used as an intermediary in the \strong{pvars} 
  functions to achieve compatibility with different classes of VAR objects.
  If the user wishes to extend this compatibility with further classes, she 
  may simply specify accordant \code{\link{as.varx}}-methods instead of altering 
  the original \strong{pvars} function. Classes already covered by \strong{pvars} 
  are those of the \strong{vars} ecosystem, in particular the classes
\itemize{
\item '\code{varest}'  for reduced-form VAR estimates from \code{\link[vars]{VAR}},
\item '\code{vec2var}' for reduced-form VECM estimates from \code{\link[vars]{vec2var}},
\item '\code{svarest}' for structural VAR estimates from \code{\link[vars]{BQ}},
\item '\code{svecest}' for structural VECM estimates from \code{\link[vars]{SVEC}}, and
\item '\code{svars}'   for structural VAR estimates from \strong{svars}' 
  \code{\link[svars]{id.chol}}, \code{\link[svars]{id.cvm}}, or \code{\link[svars]{id.dc}}.
}
  By transformation to '\code{varx}', these VAR estimates can thus be subjected 
  to \strong{pvars}' bootstrap procedure \code{\link{sboot.mb}} and S3 methods 
  such as \code{\link[base]{summary}} and \code{\link[utils]{toLatex}}.
}
\examples{
data("PCIT")
names_k = c("APITR", "ACITR", "PITB", "CITB", "GOV", "RGDP", "DEBT")

# estimate reduced-form VAR and coerce into 'varx' object #
R.vars = vars::VAR(PCIT[ , names_k], p=4, type="const")
as.varx(R.vars)

# identify structural VAR and coerce into 'id' object #
R.svar = svars::id.chol(R.vars, order_k=names_k)
as.varx(R.svar)

}
