% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/objects.R
\name{bare-type-predicates}
\alias{bare-type-predicates}
\alias{is_bare_atomic}
\alias{is_bare_character}
\alias{is_bare_double}
\alias{is_bare_integer}
\alias{is_bare_list}
\alias{is_bare_logical}
\alias{is_bare_numeric}
\alias{is_bare_vector}
\title{Bare type predicates}
\usage{
is_bare_list(x)

is_bare_atomic(x)

is_bare_vector(x)

is_bare_double(x)

is_bare_integer(x)

is_bare_numeric(x)

is_bare_character(x)

is_bare_logical(x)
}
\arguments{
\item{x}{object to be tested.}
}
\description{
These predicates check for a given type but only return \code{TRUE}
for bare R objects. Bare objects have no class attributes. For
example, a data frame is a list, but not a bare list.
}
\details{
\itemize{
  \item Like \code{\link{is_atomic}()} and unlike base R
        \code{is.atomic()}, \code{is_bare_atomic()} does not return
        \code{TRUE} for \code{NULL}.
  \item Unlike base R \code{is.numeric()}, \code{is_bare_double()}
        only return \code{TRUE} for floating point numbers.
}
}
\seealso{
type-predicates
}

