% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generic.R
\name{getRates}
\alias{getRates}
\title{Get rate values}
\usage{
getRates(object, stage, timevector = NULL, genename = NULL)
}
\arguments{
\item{object}{a 'pulseTDmodel' that has been calculated with \code{\link{estimateParams}}}

\item{stage}{A character is one of three stages of transcriptional dynamics, transcription, processing and degradation.}

\item{timevector}{A vector of time, which can be any time, defaults to NULL
\itemize{
 \item If it is NULL: only calculate the transcriptional dynamics of the measurement time node, the time is obtained by t_time in pulseTDmodel
 \item If the time vector is positive: calculate the rate value for a given time, or the predicted rate if the time exceeds the measurement time node
 \item If the time vector is negative: Calculate the rate value at a given time, which represents the calculation of the transcriptional dynamic rate before the prediction of the experimental measurement.
}}

\item{genename}{a vector, default is NULL
\itemize{
 \item If it is NULL: Calculate the transcriptional dynamic rate of all genes
 \item If it is a gene vector: only calculate the transcriptional dynamic rate of a given gene vector
 \item If it is a numerical vector: only calculate the transcriptional dynamic rate of the gene corresponding to a given value.
}}
}
\value{
A matrix, each row representing a gene, each column with a table to calculate the time node, and the value representing the rate of transcriptional dynamics.
}
\description{
It is used to calculate the transcriptional dynamic rate of a gene.
You can get the discrete or continuous rate values of the measurement time points.
At the same time, it has a predictive function that provides rate values for any future time node or any range of time.
}
\examples{
load(file.path(system.file(package="pulseTD"),"data","pulseRates.RData"))
pulseRates_correct <- correctionParams(pulseRates)
transcription = getRates(pulseRates_correct,'transcription')
degradation = getRates(pulseRates_correct, 'degradation')
processing = getRates(pulseRates_correct, 'processing')
head(transcription)
head(degradation)
head(processing)
trans = getRates(pulseRates_correct, 'transcription', timevector=c(0,1,2,3))
head(transcription)
trans=getRates(pulseRates_correct, 'transcription', timevector=c(2,3),genename=c(2,3))
head(transcription)
}
