% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{push<-.pubprint}
\alias{push<-.pubprint}
\title{Adds another item to a pubprint object}
\usage{
\method{push}{pubprint}(x, item, add = FALSE, n = 1, ...) <- value
}
\arguments{
\item{x}{a pubprint object to which \code{value} is added.}

\item{item}{numeric or character. If \code{item} is a numeric, \code{value}
is added to pipe. If \code{item} is a character, \code{value} is added to
named memory.  A warning is thrown, if an existing item is overwritten.}

\item{add}{logical, indicating if \code{value} is added to an existing item.
If \code{item} is specified, \code{value} is added to this item, else
argument \code{n} is used.}

\item{n}{numeric. If \code{item} is missing and \code{add} is true,
\code{n} indicates to which pipe position (backwards) \code{value} is added.
Therefore, \code{n = 1} adds the item to the last pipe item, \code{n = 2}
to the second last item and so on.}

\item{...}{further arguments passed to or from other methods.}

\item{value}{an item pushed to \code{x}.}
}
\value{
The updated pubprint object.
}
\description{
\code{push<-.pubprint} adds the given item to named memory or pipe of a
pubprint object.
}
\details{
No further details.
}
\examples{
ppo <- pubprint()
push(ppo) <- t.test(1:100, 2:101)
push(ppo, add = TRUE) <- .8123 # add d value to last pipe item
push(ppo, item = "i1") <- t.test(1:30, 2:31)

pull(ppo)
pull(ppo, item = "i1")

}
\seealso{
See \code{\link{push<-}} for the generic function,
\code{\link{pull}} to extract items again.
}

