% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Oncho}
\alias{Oncho}
\title{Onchocerciasis in Sierra Leone.}
\format{
A labelled tibble with 1302 rows and 7 variables:
\describe{
\item{id}{Subject ID.}
\item{mf}{Infected with Onchocerciasis volvulus, factor with levels "Not-infected" and "Infected".}
\item{area}{Area of residence, factor with levels "Savannah" and "Rainforest".}
\item{agegrp}{Age group in years, factor with levels "5-9", "10-19", "20-39" and "40+".}
\item{sex}{Subject sex, factor with levels "Male" and "Female".}
\item{mfload}{Microfiliariae load.}
\item{lesions}{Severe eye lesions, factor with levels "No" and "Yes".}
}
}
\source{
McMahon, JE, Sowa, SIC, Maude, GH and Kirkwood BR (1988) Onchocerciasis in Sierra Leone 2:
a comparison of forest and savannah villages. Trans Roy Soc Trop Med Hyg 82: 595-600.

Kirkwood, BR and Sterne, JAC (2003) Essential Medical Statistics. Second Edition. Blackwell.
}
\usage{
Oncho
}
\description{
Study of onchocerciasis ("river blindness") in Sierra Leone, in which subjects were classified according
to whether they lived in villages in savannah or rainforest area.
}
\examples{
require(dplyr, quietly = TRUE)
data(Oncho)

Oncho |>
  select(mf, agegrp) |>
  cross_tbl(by = "mf")
}
\keyword{datasets}
