% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/particlefilter.R
\name{detfun0}
\alias{detfun0}
\title{default deterministic function}
\usage{
detfun0(sdet, xt, time = NULL, ...)
}
\arguments{
\item{sdet}{a numeric vector of length two, specifying growth rate and carrying capacity}

\item{xt}{a number or numeric vector of abundances at time t}

\item{time}{the timestep - defaults to NULL (i.e. not used)}

\item{...}{additional arguments, for compatability with other usages of the function - values are not used in this implementation}
}
\value{
a number or numeric vector of length xt, with predicted abundances at time t+1
}
\description{
Simulates deterministic component of Ricker model, of the form xt+1 = xt exp(exp(sdet[1])*(1-xt/exp(sdet[2])))
}
\keyword{deterministic}
\keyword{discrete-time}
\keyword{time-series}
