% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvPSYwmboot.R
\name{cvPSYwmboot}
\alias{cvPSYwmboot}
\title{Conduct the new composite bootstrapping for the PSY test.}
\usage{
cvPSYwmboot(y, swindow0, IC = 0, adflag = 0, Tb, nboot = 199,
  useParallel = TRUE, nCores)
}
\arguments{
\item{y}{A vector. The data.}

\item{swindow0}{A positive integer. Minimum window size (default = \eqn{T
(0.01 + 1.8/\sqrt{T})}, where \eqn{T} denotes the sample size),}

\item{IC}{An integer. 0 for fixed lag order (default), 1 for AIC and 2 for
BIC (default = 0).}

\item{adflag}{An integer, lag order when IC=0; maximum number of
lags when IC>0 (default = 0).}

\item{Tb}{A positive integer. The simulated sample size (swindow0+
controlling).}

\item{nboot}{A positive integer. Number of bootstrap replications (default =
199).}

\item{useParallel}{Logical. If \code{useParallel=TRUE}, use multi core
computation.}

\item{nCores}{A positive integer. Optional. If \code{useParallel=TRUE}, the
number of cores defaults to all but one.}
}
\value{
A matrix. BSADF bootstrap critical value sequence at the 90, 95 and
  99 percent level.
}
\description{
\code{cvPSYwmboot} implements the new bootstrap procedure designed
  to detect bubbles and crisis periods while mitigating the potential impact
  of heteroskedasticity and to effect family-wise size control in recursive
  testing algorithms (Phillips and Shi, forthcoming).
}
\examples{
y <- rnorm(80)
cv <- cvPSYwmboot(y, IC = 0, adflag = 1, Tb = 30, nboot = 99, nCores = 1)

}
\references{
Phillips, P. C. B., Shi, S., & Yu, J. (2015a). Testing for
  multiple bubbles: Historical episodes of exuberance and collapse in the S&P
  500. \emph{International Economic Review}, 56(4), 1034--1078.

Phillips, P. C. B., Shi, S., & Yu, J. (2015b). Testing for
  multiple bubbles: Limit Theory for Real-Time Detectors. \emph{International
  Economic Review}, 56(4), 1079--1134.

Phillips, P. C. B., & Shi, S.(forthcoming). Real time
  monitoring of asset markets: Bubbles and crisis. In Hrishikesh D. Vinod and
  C.R. Rao (Eds.), \emph{Handbook of Statistics Volume 41 - Econometrics
  Using R}.
}
