% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_var_rho_int.R
\name{estimate_var_rho_int}
\alias{estimate_var_rho_int}
\alias{estimate_var_rho_int_meas}
\alias{estimate_var_rho_int_uvdrr}
\alias{estimate_var_rho_int_uvirr}
\alias{estimate_var_rho_int_bvirr}
\alias{estimate_var_rho_int_bvdrr}
\alias{estimate_var_rho_int_rb}
\title{Non-linear estimate of variance of \eqn{\rho} corrected for psychometric artifacts using numeric integration}
\usage{
estimate_var_rho_int_meas(mean_qx, mean_qy, var_res)

estimate_var_rho_int_uvdrr(
  mean_rxyi,
  mean_rtpa,
  mean_qxa,
  mean_qyi,
  mean_ux,
  var_res
)

estimate_var_rho_int_uvirr(
  mean_rxyi,
  mean_rtpa,
  mean_qxi,
  mean_qyi,
  mean_ut,
  var_res
)

estimate_var_rho_int_bvirr(mean_qxa, mean_qya, mean_ux, mean_uy, var_res)

estimate_var_rho_int_bvdrr(
  mean_rxyi,
  mean_rtpa,
  mean_qxa,
  mean_qya,
  mean_ux,
  mean_uy,
  var_res
)

estimate_var_rho_int_rb(
  mean_rxyi,
  mean_rtpa,
  mean_qx,
  mean_qy,
  mean_ux,
  var_res
)
}
\arguments{
\item{mean_qx}{Mean square root of reliability for X.}

\item{mean_qy}{Mean square root of reliability for Y.}

\item{var_res}{Residual variance from an interative artifact distribution (i.e., variance of observed correlations minus predicted error variance and predicted artifact variance).}

\item{mean_rxyi}{Mean observed correlation.}

\item{mean_rtpa}{Mean corrected correlation.}

\item{mean_qxa}{Mean square root of unrestricted reliability for X.}

\item{mean_qyi}{Mean square root of restricted reliability for Y.}

\item{mean_ux}{Mean observed-score u ratio for X.}

\item{mean_qxi}{Mean square root of restricted reliability for X.}

\item{mean_ut}{Mean true-score u ratio for X.}

\item{mean_qya}{Mean square root of unrestricted reliability for Y.}

\item{mean_uy}{Mean observed-score u ratio for Y.}
}
\value{
A vector of non-linear estimates of the variance of rho.
}
\description{
Functions to estimate the variance of \eqn{\rho} corrected for psychometric artifacts. These functions integrate over the residual distribution of correlations from an interactive artifact-distribution meta-analysis to non-linearly estimate the variance of \eqn{\rho}{rho}.

Available functions include:
\itemize{
     \item{\code{estimate_var_rho_int_meas}}{\cr Variance of \eqn{\rho} corrected for measurement error only}
     \item{\code{estimate_var_rho_int_uvdrr}}{\cr Variance of \eqn{\rho} corrected for univariate direct range restriction (i.e., Case II) and measurement error}
     \item{\code{estimate_var_rho_int_bvdrr}}{\cr Variance of \eqn{\rho} corrected for bivariate direct range restriction and measurement error}
     \item{\code{estimate_var_rho_int_uvirr}}{\cr Variance of \eqn{\rho} corrected for univariate indirect range restriction (i.e., Case IV) and measurement error}
     \item{\code{estimate_var_rho_int_bvirr}}{\cr Variance of \eqn{\rho} corrected for bivariate indirect range restriction (i.e., Case V) and measurement error}
     \item{\code{estimate_var_rho_int_rb}}{\cr Variance of \eqn{\rho} corrected using Raju and Burke's correction for direct range restriction and measurement error}
}
}
\section{Notes}{

\code{estimate_var_rho_int_meas} and \code{estimate_var_rho_int_bvirr} do not make use of numeric integration because they are linear functions.
}

\references{
Law, K. S., Schmidt, F. L., & Hunter, J. E. (1994).
Nonlinearity of range corrections in meta-analysis: Test of an improved procedure.
\emph{Journal of Applied Psychology, 79}(3), 425–438. \url{https://doi.org/10.1037/0021-9010.79.3.425}
}
